/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.intelligence.v2;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.intelligence.v2.PrebuiltOperator;

public class PrebuiltOperatorReader
extends Reader<PrebuiltOperator> {
    private PrebuiltOperator.Availability availability;
    private String languageCode;
    private Integer pageSize;

    public PrebuiltOperatorReader setAvailability(PrebuiltOperator.Availability availability) {
        this.availability = availability;
        return this;
    }

    public PrebuiltOperatorReader setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
        return this;
    }

    public PrebuiltOperatorReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<PrebuiltOperator> read(TwilioRestClient client) {
        return new ResourceSet<PrebuiltOperator>(this, client, this.firstPage(client));
    }

    @Override
    public Page<PrebuiltOperator> firstPage(TwilioRestClient client) {
        String path = "/v2/Operators/PreBuilt";
        Request request = new Request(HttpMethod.GET, Domains.INTELLIGENCE.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<PrebuiltOperator> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("PrebuiltOperator read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("operators", response.getContent(), PrebuiltOperator.class, client.getObjectMapper());
    }

    @Override
    public Page<PrebuiltOperator> previousPage(Page<PrebuiltOperator> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.INTELLIGENCE.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<PrebuiltOperator> nextPage(Page<PrebuiltOperator> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.INTELLIGENCE.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<PrebuiltOperator> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.availability != null) {
            request.addQueryParam("Availability", this.availability.toString());
        }
        if (this.languageCode != null) {
            request.addQueryParam("LanguageCode", this.languageCode);
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

