/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.intelligence.v2.transcript;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.intelligence.v2.transcript.Media;

public class MediaFetcher
extends Fetcher<Media> {
    private String pathSid;
    private Boolean redacted;

    public MediaFetcher(String pathSid) {
        this.pathSid = pathSid;
    }

    public MediaFetcher setRedacted(Boolean redacted) {
        this.redacted = redacted;
        return this;
    }

    @Override
    public Media fetch(TwilioRestClient client) {
        String path = "/v2/Transcripts/{Sid}/Media";
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.INTELLIGENCE.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Media fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Media.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.redacted != null) {
            request.addQueryParam("Redacted", this.redacted.toString());
        }
    }
}

