/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.intelligence.v2.transcript;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.intelligence.v2.transcript.SentenceReader;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Sentence
extends Resource {
    private static final long serialVersionUID = 171585913029090L;
    private final Integer mediaChannel;
    private final Integer sentenceIndex;
    private final BigDecimal startTime;
    private final BigDecimal endTime;
    private final String transcript;
    private final String sid;
    private final BigDecimal confidence;
    private final List<Map<String, Object>> words;

    public static SentenceReader reader(String pathTranscriptSid) {
        return new SentenceReader(pathTranscriptSid);
    }

    public static Sentence fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Sentence.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Sentence fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Sentence.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Sentence(@JsonProperty(value="media_channel") Integer mediaChannel, @JsonProperty(value="sentence_index") Integer sentenceIndex, @JsonProperty(value="start_time") BigDecimal startTime, @JsonProperty(value="end_time") BigDecimal endTime, @JsonProperty(value="transcript") String transcript, @JsonProperty(value="sid") String sid, @JsonProperty(value="confidence") BigDecimal confidence, @JsonProperty(value="words") List<Map<String, Object>> words) {
        this.mediaChannel = mediaChannel;
        this.sentenceIndex = sentenceIndex;
        this.startTime = startTime;
        this.endTime = endTime;
        this.transcript = transcript;
        this.sid = sid;
        this.confidence = confidence;
        this.words = words;
    }

    public final Integer getMediaChannel() {
        return this.mediaChannel;
    }

    public final Integer getSentenceIndex() {
        return this.sentenceIndex;
    }

    public final BigDecimal getStartTime() {
        return this.startTime;
    }

    public final BigDecimal getEndTime() {
        return this.endTime;
    }

    public final String getTranscript() {
        return this.transcript;
    }

    public final String getSid() {
        return this.sid;
    }

    public final BigDecimal getConfidence() {
        return this.confidence;
    }

    public final List<Map<String, Object>> getWords() {
        return this.words;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sentence other = (Sentence)o;
        return Objects.equals(this.mediaChannel, other.mediaChannel) && Objects.equals(this.sentenceIndex, other.sentenceIndex) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.transcript, other.transcript) && Objects.equals(this.sid, other.sid) && Objects.equals(this.confidence, other.confidence) && Objects.equals(this.words, other.words);
    }

    public int hashCode() {
        return Objects.hash(this.mediaChannel, this.sentenceIndex, this.startTime, this.endTime, this.transcript, this.sid, this.confidence, this.words);
    }

    public String toString() {
        return "Sentence(mediaChannel=" + this.getMediaChannel() + ", sentenceIndex=" + this.getSentenceIndex() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", transcript=" + this.getTranscript() + ", sid=" + this.getSid() + ", confidence=" + this.getConfidence() + ", words=" + this.getWords() + ")";
    }
}

