/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.ipmessaging.v2.service.user;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.ipmessaging.v2.service.user.UserChannel;

public class UserChannelFetcher
extends Fetcher<UserChannel> {
    private String pathServiceSid;
    private String pathUserSid;
    private String pathChannelSid;

    public UserChannelFetcher(String pathServiceSid, String pathUserSid, String pathChannelSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathUserSid = pathUserSid;
        this.pathChannelSid = pathChannelSid;
    }

    @Override
    public UserChannel fetch(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/Users/{UserSid}/Channels/{ChannelSid}";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{UserSid}", this.pathUserSid.toString());
        path = path.replace("{ChannelSid}", this.pathChannelSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.IPMESSAGING.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UserChannel fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return UserChannel.fromJson(response.getStream(), client.getObjectMapper());
    }
}

