/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.marketplace.v1.installedaddon;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.marketplace.v1.installedaddon.InstalledAddOnExtensionFetcher;
import com.twilio.rest.marketplace.v1.installedaddon.InstalledAddOnExtensionReader;
import com.twilio.rest.marketplace.v1.installedaddon.InstalledAddOnExtensionUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InstalledAddOnExtension
extends Resource {
    private static final long serialVersionUID = 244872409958696L;
    private final String sid;
    private final String installedAddOnSid;
    private final String friendlyName;
    private final String productName;
    private final String uniqueName;
    private final Boolean enabled;
    private final URI url;

    public static InstalledAddOnExtensionFetcher fetcher(String pathInstalledAddOnSid, String pathSid) {
        return new InstalledAddOnExtensionFetcher(pathInstalledAddOnSid, pathSid);
    }

    public static InstalledAddOnExtensionReader reader(String pathInstalledAddOnSid) {
        return new InstalledAddOnExtensionReader(pathInstalledAddOnSid);
    }

    public static InstalledAddOnExtensionUpdater updater(String pathInstalledAddOnSid, String pathSid, Boolean enabled) {
        return new InstalledAddOnExtensionUpdater(pathInstalledAddOnSid, pathSid, enabled);
    }

    public static InstalledAddOnExtension fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InstalledAddOnExtension.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static InstalledAddOnExtension fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InstalledAddOnExtension.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private InstalledAddOnExtension(@JsonProperty(value="sid") String sid, @JsonProperty(value="installed_add_on_sid") String installedAddOnSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="product_name") String productName, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="enabled") Boolean enabled, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.installedAddOnSid = installedAddOnSid;
        this.friendlyName = friendlyName;
        this.productName = productName;
        this.uniqueName = uniqueName;
        this.enabled = enabled;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getInstalledAddOnSid() {
        return this.installedAddOnSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getProductName() {
        return this.productName;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final Boolean getEnabled() {
        return this.enabled;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstalledAddOnExtension other = (InstalledAddOnExtension)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.installedAddOnSid, other.installedAddOnSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.productName, other.productName) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.installedAddOnSid, this.friendlyName, this.productName, this.uniqueName, this.enabled, this.url);
    }

    public String toString() {
        return "InstalledAddOnExtension(sid=" + this.getSid() + ", installedAddOnSid=" + this.getInstalledAddOnSid() + ", friendlyName=" + this.getFriendlyName() + ", productName=" + this.getProductName() + ", uniqueName=" + this.getUniqueName() + ", enabled=" + this.getEnabled() + ", url=" + this.getUrl() + ")";
    }
}

