/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.marketplace.v1.installedaddon;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.marketplace.v1.installedaddon.InstalledAddOnExtension;

public class InstalledAddOnExtensionReader
extends Reader<InstalledAddOnExtension> {
    private String pathInstalledAddOnSid;
    private Integer pageSize;

    public InstalledAddOnExtensionReader(String pathInstalledAddOnSid) {
        this.pathInstalledAddOnSid = pathInstalledAddOnSid;
    }

    public InstalledAddOnExtensionReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<InstalledAddOnExtension> read(TwilioRestClient client) {
        return new ResourceSet<InstalledAddOnExtension>(this, client, this.firstPage(client));
    }

    @Override
    public Page<InstalledAddOnExtension> firstPage(TwilioRestClient client) {
        String path = "/v1/InstalledAddOns/{InstalledAddOnSid}/Extensions";
        path = path.replace("{InstalledAddOnSid}", this.pathInstalledAddOnSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.MARKETPLACE.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<InstalledAddOnExtension> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("InstalledAddOnExtension read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("extensions", response.getContent(), InstalledAddOnExtension.class, client.getObjectMapper());
    }

    @Override
    public Page<InstalledAddOnExtension> previousPage(Page<InstalledAddOnExtension> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.MARKETPLACE.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<InstalledAddOnExtension> nextPage(Page<InstalledAddOnExtension> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.MARKETPLACE.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<InstalledAddOnExtension> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

