/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.DomainCerts;

public class DomainCertsUpdater
extends Updater<DomainCerts> {
    private String pathDomainSid;
    private String tlsCert;

    public DomainCertsUpdater(String pathDomainSid, String tlsCert) {
        this.pathDomainSid = pathDomainSid;
        this.tlsCert = tlsCert;
    }

    public DomainCertsUpdater setTlsCert(String tlsCert) {
        this.tlsCert = tlsCert;
        return this;
    }

    @Override
    public DomainCerts update(TwilioRestClient client) {
        String path = "/v1/LinkShortening/Domains/{DomainSid}/Certificate";
        path = path.replace("{DomainSid}", this.pathDomainSid.toString());
        path = path.replace("{TlsCert}", this.tlsCert.toString());
        Request request = new Request(HttpMethod.POST, Domains.MESSAGING.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DomainCerts update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return DomainCerts.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.tlsCert != null) {
            request.addPostParam("TlsCert", this.tlsCert);
        }
    }
}

