/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.TollfreeVerification;

public class TollfreeVerificationReader
extends Reader<TollfreeVerification> {
    private String tollfreePhoneNumberSid;
    private TollfreeVerification.Status status;
    private String externalReferenceId;
    private Boolean includeSubAccounts;
    private Integer pageSize;

    public TollfreeVerificationReader setTollfreePhoneNumberSid(String tollfreePhoneNumberSid) {
        this.tollfreePhoneNumberSid = tollfreePhoneNumberSid;
        return this;
    }

    public TollfreeVerificationReader setStatus(TollfreeVerification.Status status) {
        this.status = status;
        return this;
    }

    public TollfreeVerificationReader setExternalReferenceId(String externalReferenceId) {
        this.externalReferenceId = externalReferenceId;
        return this;
    }

    public TollfreeVerificationReader setIncludeSubAccounts(Boolean includeSubAccounts) {
        this.includeSubAccounts = includeSubAccounts;
        return this;
    }

    public TollfreeVerificationReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<TollfreeVerification> read(TwilioRestClient client) {
        return new ResourceSet<TollfreeVerification>(this, client, this.firstPage(client));
    }

    @Override
    public Page<TollfreeVerification> firstPage(TwilioRestClient client) {
        String path = "/v1/Tollfree/Verifications";
        Request request = new Request(HttpMethod.GET, Domains.MESSAGING.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<TollfreeVerification> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TollfreeVerification read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("verifications", response.getContent(), TollfreeVerification.class, client.getObjectMapper());
    }

    @Override
    public Page<TollfreeVerification> previousPage(Page<TollfreeVerification> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.MESSAGING.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<TollfreeVerification> nextPage(Page<TollfreeVerification> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.MESSAGING.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<TollfreeVerification> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.tollfreePhoneNumberSid != null) {
            request.addQueryParam("TollfreePhoneNumberSid", this.tollfreePhoneNumberSid);
        }
        if (this.status != null) {
            request.addQueryParam("Status", this.status.toString());
        }
        if (this.externalReferenceId != null) {
            request.addQueryParam("ExternalReferenceId", this.externalReferenceId);
        }
        if (this.includeSubAccounts != null) {
            request.addQueryParam("IncludeSubAccounts", this.includeSubAccounts.toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

