/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1.service;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.service.ChannelSender;

public class ChannelSenderCreator
extends Creator<ChannelSender> {
    private String pathMessagingServiceSid;
    private String sid;

    public ChannelSenderCreator(String pathMessagingServiceSid, String sid) {
        this.pathMessagingServiceSid = pathMessagingServiceSid;
        this.sid = sid;
    }

    public ChannelSenderCreator setSid(String sid) {
        this.sid = sid;
        return this;
    }

    @Override
    public ChannelSender create(TwilioRestClient client) {
        String path = "/v1/Services/{MessagingServiceSid}/ChannelSenders";
        path = path.replace("{MessagingServiceSid}", this.pathMessagingServiceSid.toString());
        path = path.replace("{Sid}", this.sid.toString());
        Request request = new Request(HttpMethod.POST, Domains.MESSAGING.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ChannelSender creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return ChannelSender.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.sid != null) {
            request.addPostParam("Sid", this.sid);
        }
    }
}

