/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1.service;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.service.ChannelSender;

public class ChannelSenderFetcher
extends Fetcher<ChannelSender> {
    private String pathMessagingServiceSid;
    private String pathSid;

    public ChannelSenderFetcher(String pathMessagingServiceSid, String pathSid) {
        this.pathMessagingServiceSid = pathMessagingServiceSid;
        this.pathSid = pathSid;
    }

    @Override
    public ChannelSender fetch(TwilioRestClient client) {
        String path = "/v1/Services/{MessagingServiceSid}/ChannelSenders/{Sid}";
        path = path.replace("{MessagingServiceSid}", this.pathMessagingServiceSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.MESSAGING.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ChannelSender fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return ChannelSender.fromJson(response.getStream(), client.getObjectMapper());
    }
}

