/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.microvisor.v1.device;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.microvisor.v1.device.DeviceConfigCreator;
import com.twilio.rest.microvisor.v1.device.DeviceConfigDeleter;
import com.twilio.rest.microvisor.v1.device.DeviceConfigFetcher;
import com.twilio.rest.microvisor.v1.device.DeviceConfigReader;
import com.twilio.rest.microvisor.v1.device.DeviceConfigUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DeviceConfig
extends Resource {
    private static final long serialVersionUID = 4121523224128L;
    private final String deviceSid;
    private final String key;
    private final String value;
    private final ZonedDateTime dateUpdated;
    private final URI url;

    public static DeviceConfigCreator creator(String pathDeviceSid, String key, String value) {
        return new DeviceConfigCreator(pathDeviceSid, key, value);
    }

    public static DeviceConfigDeleter deleter(String pathDeviceSid, String pathKey) {
        return new DeviceConfigDeleter(pathDeviceSid, pathKey);
    }

    public static DeviceConfigFetcher fetcher(String pathDeviceSid, String pathKey) {
        return new DeviceConfigFetcher(pathDeviceSid, pathKey);
    }

    public static DeviceConfigReader reader(String pathDeviceSid) {
        return new DeviceConfigReader(pathDeviceSid);
    }

    public static DeviceConfigUpdater updater(String pathDeviceSid, String pathKey, String value) {
        return new DeviceConfigUpdater(pathDeviceSid, pathKey, value);
    }

    public static DeviceConfig fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, DeviceConfig.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static DeviceConfig fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, DeviceConfig.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private DeviceConfig(@JsonProperty(value="device_sid") String deviceSid, @JsonProperty(value="key") String key, @JsonProperty(value="value") String value, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.deviceSid = deviceSid;
        this.key = key;
        this.value = value;
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getDeviceSid() {
        return this.deviceSid;
    }

    public final String getKey() {
        return this.key;
    }

    public final String getValue() {
        return this.value;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceConfig other = (DeviceConfig)o;
        return Objects.equals(this.deviceSid, other.deviceSid) && Objects.equals(this.key, other.key) && Objects.equals(this.value, other.value) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.deviceSid, this.key, this.value, this.dateUpdated, this.url);
    }

    public String toString() {
        return "DeviceConfig(deviceSid=" + this.getDeviceSid() + ", key=" + this.getKey() + ", value=" + this.getValue() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ")";
    }
}

