/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.monitor.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.monitor.v1.Event;
import java.time.ZonedDateTime;

public class EventReader
extends Reader<Event> {
    private String actorSid;
    private String eventType;
    private String resourceSid;
    private String sourceIpAddress;
    private ZonedDateTime startDate;
    private ZonedDateTime endDate;
    private Integer pageSize;

    public EventReader setActorSid(String actorSid) {
        this.actorSid = actorSid;
        return this;
    }

    public EventReader setEventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    public EventReader setResourceSid(String resourceSid) {
        this.resourceSid = resourceSid;
        return this;
    }

    public EventReader setSourceIpAddress(String sourceIpAddress) {
        this.sourceIpAddress = sourceIpAddress;
        return this;
    }

    public EventReader setStartDate(ZonedDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    public EventReader setEndDate(ZonedDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    public EventReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Event> read(TwilioRestClient client) {
        return new ResourceSet<Event>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Event> firstPage(TwilioRestClient client) {
        String path = "/v1/Events";
        Request request = new Request(HttpMethod.GET, Domains.MONITOR.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<Event> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Event read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("events", response.getContent(), Event.class, client.getObjectMapper());
    }

    @Override
    public Page<Event> previousPage(Page<Event> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.MONITOR.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Event> nextPage(Page<Event> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.MONITOR.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Event> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.actorSid != null) {
            request.addQueryParam("ActorSid", this.actorSid);
        }
        if (this.eventType != null) {
            request.addQueryParam("EventType", this.eventType);
        }
        if (this.resourceSid != null) {
            request.addQueryParam("ResourceSid", this.resourceSid);
        }
        if (this.sourceIpAddress != null) {
            request.addQueryParam("SourceIpAddress", this.sourceIpAddress);
        }
        if (this.startDate != null) {
            request.addQueryParam("StartDate", this.startDate.toInstant().toString());
        }
        if (this.endDate != null) {
            request.addQueryParam("EndDate", this.endDate.toInstant().toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

