/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.numbers.v1.PortingPortInPhoneNumberDeleter;
import com.twilio.rest.numbers.v1.PortingPortInPhoneNumberFetcher;
import com.twilio.type.PhoneNumber;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PortingPortInPhoneNumber
extends Resource {
    private static final long serialVersionUID = 167748348431012L;
    private final String portInRequestSid;
    private final String phoneNumberSid;
    private final URI url;
    private final String accountSid;
    private final String phoneNumberType;
    private final ZonedDateTime dateCreated;
    private final String country;
    private final Boolean missingRequiredFields;
    private final ZonedDateTime lastUpdated;
    private final PhoneNumber phoneNumber;
    private final Boolean portable;
    private final String notPortabilityReason;
    private final Integer notPortabilityReasonCode;
    private final String portInPhoneNumberStatus;
    private final Integer portOutPin;
    private final String rejectionReason;
    private final Integer rejectionReasonCode;
    private final ZonedDateTime portDate;

    public static PortingPortInPhoneNumberDeleter deleter(String pathPortInRequestSid, String pathPhoneNumberSid) {
        return new PortingPortInPhoneNumberDeleter(pathPortInRequestSid, pathPhoneNumberSid);
    }

    public static PortingPortInPhoneNumberFetcher fetcher(String pathPortInRequestSid, String pathPhoneNumberSid) {
        return new PortingPortInPhoneNumberFetcher(pathPortInRequestSid, pathPhoneNumberSid);
    }

    public static PortingPortInPhoneNumber fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, PortingPortInPhoneNumber.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static PortingPortInPhoneNumber fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, PortingPortInPhoneNumber.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private PortingPortInPhoneNumber(@JsonProperty(value="port_in_request_sid") String portInRequestSid, @JsonProperty(value="phone_number_sid") String phoneNumberSid, @JsonProperty(value="url") URI url, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="phone_number_type") String phoneNumberType, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="country") String country, @JsonProperty(value="missing_required_fields") Boolean missingRequiredFields, @JsonProperty(value="last_updated") String lastUpdated, @JsonProperty(value="phone_number") PhoneNumber phoneNumber, @JsonProperty(value="portable") Boolean portable, @JsonProperty(value="not_portability_reason") String notPortabilityReason, @JsonProperty(value="not_portability_reason_code") Integer notPortabilityReasonCode, @JsonProperty(value="port_in_phone_number_status") String portInPhoneNumberStatus, @JsonProperty(value="port_out_pin") Integer portOutPin, @JsonProperty(value="rejection_reason") String rejectionReason, @JsonProperty(value="rejection_reason_code") Integer rejectionReasonCode, @JsonProperty(value="port_date") String portDate) {
        this.portInRequestSid = portInRequestSid;
        this.phoneNumberSid = phoneNumberSid;
        this.url = url;
        this.accountSid = accountSid;
        this.phoneNumberType = phoneNumberType;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.country = country;
        this.missingRequiredFields = missingRequiredFields;
        this.lastUpdated = DateConverter.iso8601DateTimeFromString(lastUpdated);
        this.phoneNumber = phoneNumber;
        this.portable = portable;
        this.notPortabilityReason = notPortabilityReason;
        this.notPortabilityReasonCode = notPortabilityReasonCode;
        this.portInPhoneNumberStatus = portInPhoneNumberStatus;
        this.portOutPin = portOutPin;
        this.rejectionReason = rejectionReason;
        this.rejectionReasonCode = rejectionReasonCode;
        this.portDate = DateConverter.iso8601DateTimeFromString(portDate);
    }

    public final String getPortInRequestSid() {
        return this.portInRequestSid;
    }

    public final String getPhoneNumberSid() {
        return this.phoneNumberSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getPhoneNumberType() {
        return this.phoneNumberType;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final String getCountry() {
        return this.country;
    }

    public final Boolean getMissingRequiredFields() {
        return this.missingRequiredFields;
    }

    public final ZonedDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public final PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    public final Boolean getPortable() {
        return this.portable;
    }

    public final String getNotPortabilityReason() {
        return this.notPortabilityReason;
    }

    public final Integer getNotPortabilityReasonCode() {
        return this.notPortabilityReasonCode;
    }

    public final String getPortInPhoneNumberStatus() {
        return this.portInPhoneNumberStatus;
    }

    public final Integer getPortOutPin() {
        return this.portOutPin;
    }

    public final String getRejectionReason() {
        return this.rejectionReason;
    }

    public final Integer getRejectionReasonCode() {
        return this.rejectionReasonCode;
    }

    public final ZonedDateTime getPortDate() {
        return this.portDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortingPortInPhoneNumber other = (PortingPortInPhoneNumber)o;
        return Objects.equals(this.portInRequestSid, other.portInRequestSid) && Objects.equals(this.phoneNumberSid, other.phoneNumberSid) && Objects.equals(this.url, other.url) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.phoneNumberType, other.phoneNumberType) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.country, other.country) && Objects.equals(this.missingRequiredFields, other.missingRequiredFields) && Objects.equals(this.lastUpdated, other.lastUpdated) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.portable, other.portable) && Objects.equals(this.notPortabilityReason, other.notPortabilityReason) && Objects.equals(this.notPortabilityReasonCode, other.notPortabilityReasonCode) && Objects.equals(this.portInPhoneNumberStatus, other.portInPhoneNumberStatus) && Objects.equals(this.portOutPin, other.portOutPin) && Objects.equals(this.rejectionReason, other.rejectionReason) && Objects.equals(this.rejectionReasonCode, other.rejectionReasonCode) && Objects.equals(this.portDate, other.portDate);
    }

    public int hashCode() {
        return Objects.hash(this.portInRequestSid, this.phoneNumberSid, this.url, this.accountSid, this.phoneNumberType, this.dateCreated, this.country, this.missingRequiredFields, this.lastUpdated, this.phoneNumber, this.portable, this.notPortabilityReason, this.notPortabilityReasonCode, this.portInPhoneNumberStatus, this.portOutPin, this.rejectionReason, this.rejectionReasonCode, this.portDate);
    }

    public String toString() {
        return "PortingPortInPhoneNumber(portInRequestSid=" + this.getPortInRequestSid() + ", phoneNumberSid=" + this.getPhoneNumberSid() + ", url=" + this.getUrl() + ", accountSid=" + this.getAccountSid() + ", phoneNumberType=" + this.getPhoneNumberType() + ", dateCreated=" + this.getDateCreated() + ", country=" + this.getCountry() + ", missingRequiredFields=" + this.getMissingRequiredFields() + ", lastUpdated=" + this.getLastUpdated() + ", phoneNumber=" + this.getPhoneNumber() + ", portable=" + this.getPortable() + ", notPortabilityReason=" + this.getNotPortabilityReason() + ", notPortabilityReasonCode=" + this.getNotPortabilityReasonCode() + ", portInPhoneNumberStatus=" + this.getPortInPhoneNumberStatus() + ", portOutPin=" + this.getPortOutPin() + ", rejectionReason=" + this.getRejectionReason() + ", rejectionReasonCode=" + this.getRejectionReasonCode() + ", portDate=" + this.getPortDate() + ")";
    }
}

