/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v1;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.numbers.v1.PortingPortInPhoneNumber;

public class PortingPortInPhoneNumberFetcher
extends Fetcher<PortingPortInPhoneNumber> {
    private String pathPortInRequestSid;
    private String pathPhoneNumberSid;

    public PortingPortInPhoneNumberFetcher(String pathPortInRequestSid, String pathPhoneNumberSid) {
        this.pathPortInRequestSid = pathPortInRequestSid;
        this.pathPhoneNumberSid = pathPhoneNumberSid;
    }

    @Override
    public PortingPortInPhoneNumber fetch(TwilioRestClient client) {
        String path = "/v1/Porting/PortIn/{PortInRequestSid}/PhoneNumber/{PhoneNumberSid}";
        path = path.replace("{PortInRequestSid}", this.pathPortInRequestSid.toString());
        path = path.replace("{PhoneNumberSid}", this.pathPhoneNumberSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.NUMBERS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("PortingPortInPhoneNumber fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return PortingPortInPhoneNumber.fromJson(response.getStream(), client.getObjectMapper());
    }
}

