/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.deployedDevices.fleet;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.deployedDevices.fleet.Deployment;

public class DeploymentCreator
extends Creator<Deployment> {
    private String pathFleetSid;
    private String friendlyName;
    private String syncServiceSid;

    public DeploymentCreator(String pathFleetSid) {
        this.pathFleetSid = pathFleetSid;
    }

    public DeploymentCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public DeploymentCreator setSyncServiceSid(String syncServiceSid) {
        this.syncServiceSid = syncServiceSid;
        return this;
    }

    @Override
    public Deployment create(TwilioRestClient client) {
        String path = "/DeployedDevices/Fleets/{FleetSid}/Deployments";
        path = path.replace("{FleetSid}", this.pathFleetSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Deployment creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Deployment.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.syncServiceSid != null) {
            request.addPostParam("SyncServiceSid", this.syncServiceSid);
        }
    }
}

