/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.deployedDevices.fleet;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.deployedDevices.fleet.Device;

public class DeviceCreator
extends Creator<Device> {
    private String pathFleetSid;
    private String uniqueName;
    private String friendlyName;
    private String identity;
    private String deploymentSid;
    private Boolean enabled;

    public DeviceCreator(String pathFleetSid) {
        this.pathFleetSid = pathFleetSid;
    }

    public DeviceCreator setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public DeviceCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public DeviceCreator setIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    public DeviceCreator setDeploymentSid(String deploymentSid) {
        this.deploymentSid = deploymentSid;
        return this;
    }

    public DeviceCreator setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    public Device create(TwilioRestClient client) {
        String path = "/DeployedDevices/Fleets/{FleetSid}/Devices";
        path = path.replace("{FleetSid}", this.pathFleetSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Device creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Device.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.identity != null) {
            request.addPostParam("Identity", this.identity);
        }
        if (this.deploymentSid != null) {
            request.addPostParam("DeploymentSid", this.deploymentSid);
        }
        if (this.enabled != null) {
            request.addPostParam("Enabled", this.enabled.toString());
        }
    }
}

