/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.hostedNumbers;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.hostedNumbers.HostedNumberOrder;
import java.util.List;

public class HostedNumberOrderUpdater
extends Updater<HostedNumberOrder> {
    private String pathSid;
    private String friendlyName;
    private String uniqueName;
    private String email;
    private List<String> ccEmails;
    private HostedNumberOrder.Status status;
    private String verificationCode;
    private HostedNumberOrder.VerificationType verificationType;
    private String verificationDocumentSid;
    private String extension;
    private Integer callDelay;

    public HostedNumberOrderUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public HostedNumberOrderUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public HostedNumberOrderUpdater setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public HostedNumberOrderUpdater setEmail(String email) {
        this.email = email;
        return this;
    }

    public HostedNumberOrderUpdater setCcEmails(List<String> ccEmails) {
        this.ccEmails = ccEmails;
        return this;
    }

    public HostedNumberOrderUpdater setCcEmails(String ccEmails) {
        return this.setCcEmails(Promoter.listOfOne(ccEmails));
    }

    public HostedNumberOrderUpdater setStatus(HostedNumberOrder.Status status) {
        this.status = status;
        return this;
    }

    public HostedNumberOrderUpdater setVerificationCode(String verificationCode) {
        this.verificationCode = verificationCode;
        return this;
    }

    public HostedNumberOrderUpdater setVerificationType(HostedNumberOrder.VerificationType verificationType) {
        this.verificationType = verificationType;
        return this;
    }

    public HostedNumberOrderUpdater setVerificationDocumentSid(String verificationDocumentSid) {
        this.verificationDocumentSid = verificationDocumentSid;
        return this;
    }

    public HostedNumberOrderUpdater setExtension(String extension) {
        this.extension = extension;
        return this;
    }

    public HostedNumberOrderUpdater setCallDelay(Integer callDelay) {
        this.callDelay = callDelay;
        return this;
    }

    @Override
    public HostedNumberOrder update(TwilioRestClient client) {
        String path = "/HostedNumbers/HostedNumberOrders/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("HostedNumberOrder update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return HostedNumberOrder.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.email != null) {
            request.addPostParam("Email", this.email);
        }
        if (this.ccEmails != null) {
            for (String prop : this.ccEmails) {
                request.addPostParam("CcEmails", prop);
            }
        }
        if (this.status != null) {
            request.addPostParam("Status", this.status.toString());
        }
        if (this.verificationCode != null) {
            request.addPostParam("VerificationCode", this.verificationCode);
        }
        if (this.verificationType != null) {
            request.addPostParam("VerificationType", this.verificationType.toString());
        }
        if (this.verificationDocumentSid != null) {
            request.addPostParam("VerificationDocumentSid", this.verificationDocumentSid);
        }
        if (this.extension != null) {
            request.addPostParam("Extension", this.extension);
        }
        if (this.callDelay != null) {
            request.addPostParam("CallDelay", this.callDelay.toString());
        }
    }
}

