/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.sync.service;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.sync.service.Document;

public class DocumentReader
extends Reader<Document> {
    private String pathServiceSid;
    private Integer pageSize;

    public DocumentReader(String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    public DocumentReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Document> read(TwilioRestClient client) {
        return new ResourceSet<Document>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Document> firstPage(TwilioRestClient client) {
        String path = "/Sync/Services/{ServiceSid}/Documents";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.PREVIEW.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<Document> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Document read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("documents", response.getContent(), Document.class, client.getObjectMapper());
    }

    @Override
    public Page<Document> previousPage(Page<Document> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.PREVIEW.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Document> nextPage(Page<Document> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.PREVIEW.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Document> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

