/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.sync.service.document;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.sync.service.document.DocumentPermission;

public class DocumentPermissionFetcher
extends Fetcher<DocumentPermission> {
    private String pathServiceSid;
    private String pathDocumentSid;
    private String pathIdentity;

    public DocumentPermissionFetcher(String pathServiceSid, String pathDocumentSid, String pathIdentity) {
        this.pathServiceSid = pathServiceSid;
        this.pathDocumentSid = pathDocumentSid;
        this.pathIdentity = pathIdentity;
    }

    @Override
    public DocumentPermission fetch(TwilioRestClient client) {
        String path = "/Sync/Services/{ServiceSid}/Documents/{DocumentSid}/Permissions/{Identity}";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{DocumentSid}", this.pathDocumentSid.toString());
        path = path.replace("{Identity}", this.pathIdentity.toString());
        Request request = new Request(HttpMethod.GET, Domains.PREVIEW.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DocumentPermission fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return DocumentPermission.fromJson(response.getStream(), client.getObjectMapper());
    }
}

