/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.previewiam.organizations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.bearertoken.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.previewiam.organizations.RoleAssignmentCreator;
import com.twilio.rest.previewiam.organizations.RoleAssignmentDeleter;
import com.twilio.rest.previewiam.organizations.RoleAssignmentReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RoleAssignment
extends Resource {
    private static final long serialVersionUID = 175566213667704L;
    private final String sid;
    private final String roleSid;
    private final String scope;
    private final String identity;

    public static RoleAssignmentCreator creator(String pathOrganizationSid, PublicApiCreateRoleAssignmentRequest publicApiCreateRoleAssignmentRequest) {
        return new RoleAssignmentCreator(pathOrganizationSid, publicApiCreateRoleAssignmentRequest);
    }

    public static RoleAssignmentDeleter deleter(String pathOrganizationSid, String pathRoleAssignmentSid) {
        return new RoleAssignmentDeleter(pathOrganizationSid, pathRoleAssignmentSid);
    }

    public static RoleAssignmentReader reader(String pathOrganizationSid) {
        return new RoleAssignmentReader(pathOrganizationSid);
    }

    public static RoleAssignment fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, RoleAssignment.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static RoleAssignment fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, RoleAssignment.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static String toJson(Object object, ObjectMapper mapper) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (JsonProcessingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private RoleAssignment(@JsonProperty(value="sid") String sid, @JsonProperty(value="role_sid") String roleSid, @JsonProperty(value="scope") String scope, @JsonProperty(value="identity") String identity) {
        this.sid = sid;
        this.roleSid = roleSid;
        this.scope = scope;
        this.identity = identity;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getRoleSid() {
        return this.roleSid;
    }

    public final String getScope() {
        return this.scope;
    }

    public final String getIdentity() {
        return this.identity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoleAssignment other = (RoleAssignment)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.roleSid, other.roleSid) && Objects.equals(this.scope, other.scope) && Objects.equals(this.identity, other.identity);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.roleSid, this.scope, this.identity);
    }

    public String toString() {
        return "RoleAssignment(sid=" + this.getSid() + ", roleSid=" + this.getRoleSid() + ", scope=" + this.getScope() + ", identity=" + this.getIdentity() + ")";
    }

    public static class PublicApiCreateRoleAssignmentRequest {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="role_sid")
        private String roleSid;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="scope")
        private String scope;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="identity")
        private String identity;

        public PublicApiCreateRoleAssignmentRequest(String roleSid, String scope, String identity) {
            this.roleSid = roleSid;
            this.scope = scope;
            this.identity = identity;
        }

        public static PublicApiCreateRoleAssignmentRequest fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, PublicApiCreateRoleAssignmentRequest.class);
        }

        public String toString() {
            return "RoleAssignment.PublicApiCreateRoleAssignmentRequest(roleSid=" + this.getRoleSid() + ", scope=" + this.getScope() + ", identity=" + this.getIdentity() + ")";
        }

        public String getRoleSid() {
            return this.roleSid;
        }

        @JsonProperty(value="role_sid")
        public void setRoleSid(String roleSid) {
            this.roleSid = roleSid;
        }

        public String getScope() {
            return this.scope;
        }

        @JsonProperty(value="scope")
        public void setScope(String scope) {
            this.scope = scope;
        }

        public String getIdentity() {
            return this.identity;
        }

        @JsonProperty(value="identity")
        public void setIdentity(String identity) {
            this.identity = identity;
        }
    }
}

