/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.previewiam.organizations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.bearertoken.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.previewiam.organizations.UserCreator;
import com.twilio.rest.previewiam.organizations.UserDeleter;
import com.twilio.rest.previewiam.organizations.UserFetcher;
import com.twilio.rest.previewiam.organizations.UserReader;
import com.twilio.rest.previewiam.organizations.UserUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class User
extends Resource {
    private static final long serialVersionUID = 281207691925540L;
    private final String id;
    private final String externalId;
    private final String userName;
    private final String displayName;
    private final ScimName name;
    private final List<ScimEmailAddress> emails;
    private final Boolean active;
    private final String locale;
    private final String timezone;
    private final List<String> schemas;
    private final ScimMeta meta;

    public static UserCreator creator(String pathOrganizationSid, ScimUser scimUser) {
        return new UserCreator(pathOrganizationSid, scimUser);
    }

    public static UserDeleter deleter(String pathOrganizationSid, String pathUserSid) {
        return new UserDeleter(pathOrganizationSid, pathUserSid);
    }

    public static UserFetcher fetcher(String pathOrganizationSid, String pathUserSid) {
        return new UserFetcher(pathOrganizationSid, pathUserSid);
    }

    public static UserReader reader(String pathOrganizationSid) {
        return new UserReader(pathOrganizationSid);
    }

    public static UserUpdater updater(String pathOrganizationSid, String pathUserSid, ScimUser scimUser) {
        return new UserUpdater(pathOrganizationSid, pathUserSid, scimUser);
    }

    public static User fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, User.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static User fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, User.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static String toJson(Object object, ObjectMapper mapper) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (JsonProcessingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private User(@JsonProperty(value="id") String id, @JsonProperty(value="external_id") String externalId, @JsonProperty(value="user_name") String userName, @JsonProperty(value="display_name") String displayName, @JsonProperty(value="name") ScimName name, @JsonProperty(value="emails") List<ScimEmailAddress> emails, @JsonProperty(value="active") Boolean active, @JsonProperty(value="locale") String locale, @JsonProperty(value="timezone") String timezone, @JsonProperty(value="schemas") List<String> schemas, @JsonProperty(value="meta") ScimMeta meta) {
        this.id = id;
        this.externalId = externalId;
        this.userName = userName;
        this.displayName = displayName;
        this.name = name;
        this.emails = emails;
        this.active = active;
        this.locale = locale;
        this.timezone = timezone;
        this.schemas = schemas;
        this.meta = meta;
    }

    public final String getId() {
        return this.id;
    }

    public final String getExternalId() {
        return this.externalId;
    }

    public final String getUserName() {
        return this.userName;
    }

    public final String getDisplayName() {
        return this.displayName;
    }

    public final ScimName getName() {
        return this.name;
    }

    public final List<ScimEmailAddress> getEmails() {
        return this.emails;
    }

    public final Boolean getActive() {
        return this.active;
    }

    public final String getLocale() {
        return this.locale;
    }

    public final String getTimezone() {
        return this.timezone;
    }

    public final List<String> getSchemas() {
        return this.schemas;
    }

    public final ScimMeta getMeta() {
        return this.meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User other = (User)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.externalId, other.externalId) && Objects.equals(this.userName, other.userName) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.name, other.name) && Objects.equals(this.emails, other.emails) && Objects.equals(this.active, other.active) && Objects.equals(this.locale, other.locale) && Objects.equals(this.timezone, other.timezone) && Objects.equals(this.schemas, other.schemas) && Objects.equals(this.meta, other.meta);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.externalId, this.userName, this.displayName, this.name, this.emails, this.active, this.locale, this.timezone, this.schemas, this.meta);
    }

    public String toString() {
        return "User(id=" + this.getId() + ", externalId=" + this.getExternalId() + ", userName=" + this.getUserName() + ", displayName=" + this.getDisplayName() + ", name=" + this.getName() + ", emails=" + this.getEmails() + ", active=" + this.getActive() + ", locale=" + this.getLocale() + ", timezone=" + this.getTimezone() + ", schemas=" + this.getSchemas() + ", meta=" + this.getMeta() + ")";
    }

    public static class ScimUser {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="id")
        private String id;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="externalId")
        private String externalId;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="userName")
        private String userName;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="name")
        private ScimName name;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="emails")
        private List<ScimEmailAddress> emails;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="active")
        private Boolean active;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="locale")
        private String locale;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="timezone")
        private String timezone;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="schemas")
        private List<String> schemas;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="meta")
        private ScimMeta meta;

        public ScimUser(String userName) {
            this.userName = userName;
        }

        public static ScimUser fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, ScimUser.class);
        }

        public String toString() {
            return "User.ScimUser(id=" + this.getId() + ", externalId=" + this.getExternalId() + ", userName=" + this.getUserName() + ", displayName=" + this.getDisplayName() + ", name=" + this.getName() + ", emails=" + this.getEmails() + ", active=" + this.getActive() + ", locale=" + this.getLocale() + ", timezone=" + this.getTimezone() + ", schemas=" + this.getSchemas() + ", meta=" + this.getMeta() + ")";
        }

        public String getId() {
            return this.id;
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        public String getExternalId() {
            return this.externalId;
        }

        @JsonProperty(value="externalId")
        public void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        public String getUserName() {
            return this.userName;
        }

        @JsonProperty(value="userName")
        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        @JsonProperty(value="displayName")
        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public ScimName getName() {
            return this.name;
        }

        @JsonProperty(value="name")
        public void setName(ScimName name) {
            this.name = name;
        }

        public List<ScimEmailAddress> getEmails() {
            return this.emails;
        }

        @JsonProperty(value="emails")
        public void setEmails(List<ScimEmailAddress> emails) {
            this.emails = emails;
        }

        public Boolean getActive() {
            return this.active;
        }

        @JsonProperty(value="active")
        public void setActive(Boolean active) {
            this.active = active;
        }

        public String getLocale() {
            return this.locale;
        }

        @JsonProperty(value="locale")
        public void setLocale(String locale) {
            this.locale = locale;
        }

        public String getTimezone() {
            return this.timezone;
        }

        @JsonProperty(value="timezone")
        public void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public List<String> getSchemas() {
            return this.schemas;
        }

        @JsonProperty(value="schemas")
        public void setSchemas(List<String> schemas) {
            this.schemas = schemas;
        }

        public ScimMeta getMeta() {
            return this.meta;
        }

        @JsonProperty(value="meta")
        public void setMeta(ScimMeta meta) {
            this.meta = meta;
        }
    }

    public static class ScimMeta {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="resourceType")
        private String resourceType;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="created")
        private ZonedDateTime created;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="lastModified")
        private ZonedDateTime lastModified;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="version")
        private String version;

        public String getCreated() {
            return this.created.toInstant().toString();
        }

        public String getLastModified() {
            return this.lastModified.toInstant().toString();
        }

        public static ScimMeta fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, ScimMeta.class);
        }

        public String toString() {
            return "User.ScimMeta(resourceType=" + this.getResourceType() + ", created=" + this.getCreated() + ", lastModified=" + this.getLastModified() + ", version=" + this.getVersion() + ")";
        }

        public String getResourceType() {
            return this.resourceType;
        }

        @JsonProperty(value="resourceType")
        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @JsonProperty(value="created")
        public void setCreated(ZonedDateTime created) {
            this.created = created;
        }

        @JsonProperty(value="lastModified")
        public void setLastModified(ZonedDateTime lastModified) {
            this.lastModified = lastModified;
        }

        public String getVersion() {
            return this.version;
        }

        @JsonProperty(value="version")
        public void setVersion(String version) {
            this.version = version;
        }
    }

    public static class ScimEmailAddress {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="primary")
        private Boolean primary;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="value")
        private String value;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="type")
        private String type;

        public static ScimEmailAddress fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, ScimEmailAddress.class);
        }

        public String toString() {
            return "User.ScimEmailAddress(primary=" + this.getPrimary() + ", value=" + this.getValue() + ", type=" + this.getType() + ")";
        }

        public Boolean getPrimary() {
            return this.primary;
        }

        @JsonProperty(value="primary")
        public void setPrimary(Boolean primary) {
            this.primary = primary;
        }

        public String getValue() {
            return this.value;
        }

        @JsonProperty(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        @JsonProperty(value="type")
        public void setType(String type) {
            this.type = type;
        }
    }

    public static class ScimName {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="givenName")
        private String givenName;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="familyName")
        private String familyName;

        public static ScimName fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, ScimName.class);
        }

        public String toString() {
            return "User.ScimName(givenName=" + this.getGivenName() + ", familyName=" + this.getFamilyName() + ")";
        }

        public String getGivenName() {
            return this.givenName;
        }

        @JsonProperty(value="givenName")
        public void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        public String getFamilyName() {
            return this.familyName;
        }

        @JsonProperty(value="familyName")
        public void setFamilyName(String familyName) {
            this.familyName = familyName;
        }
    }
}

