/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.previewiam.organizations;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.bearertoken.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Response;
import com.twilio.http.bearertoken.BearerTokenRequest;
import com.twilio.http.bearertoken.BearerTokenTwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.previewiam.organizations.User;

public class UserCreator
extends Creator<User> {
    private String pathOrganizationSid;
    private User.ScimUser scimUser;

    public UserCreator(String pathOrganizationSid, User.ScimUser scimUser) {
        this.pathOrganizationSid = pathOrganizationSid;
        this.scimUser = scimUser;
    }

    public UserCreator setScimUser(User.ScimUser scimUser) {
        this.scimUser = scimUser;
        return this;
    }

    @Override
    public User create(BearerTokenTwilioRestClient client) {
        String path = "/Organizations/{OrganizationSid}/scim/Users";
        path = path.replace("{OrganizationSid}", this.pathOrganizationSid.toString());
        path = path.replace("{ScimUser}", this.scimUser.toString());
        BearerTokenRequest request = new BearerTokenRequest(HttpMethod.POST, Domains.PREVIEWIAM.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request, client);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("User creation failed: Unable to connect to server");
        }
        if (!BearerTokenTwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return User.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(BearerTokenRequest request, BearerTokenTwilioRestClient client) {
        ObjectMapper objectMapper = client.getObjectMapper();
        if (this.scimUser != null) {
            request.setBody(User.toJson(this.scimUser, objectMapper));
        }
    }
}

