/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.previewiam.organizations;

import com.twilio.base.bearertoken.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Response;
import com.twilio.http.bearertoken.BearerTokenRequest;
import com.twilio.http.bearertoken.BearerTokenTwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.previewiam.organizations.User;

public class UserFetcher
extends Fetcher<User> {
    private String pathOrganizationSid;
    private String pathUserSid;

    public UserFetcher(String pathOrganizationSid, String pathUserSid) {
        this.pathOrganizationSid = pathOrganizationSid;
        this.pathUserSid = pathUserSid;
    }

    @Override
    public User fetch(BearerTokenTwilioRestClient client) {
        String path = "/Organizations/{OrganizationSid}/scim/Users/{UserSid}";
        path = path.replace("{OrganizationSid}", this.pathOrganizationSid.toString());
        path = path.replace("{UserSid}", this.pathUserSid.toString());
        BearerTokenRequest request = new BearerTokenRequest(HttpMethod.GET, Domains.PREVIEWIAM.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("User fetch failed: Unable to connect to server");
        }
        if (!BearerTokenTwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return User.fromJson(response.getStream(), client.getObjectMapper());
    }
}

