/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.previewiam.organizations;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.bearertoken.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Response;
import com.twilio.http.bearertoken.BearerTokenRequest;
import com.twilio.http.bearertoken.BearerTokenTwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.previewiam.organizations.User;

public class UserUpdater
extends Updater<User> {
    private String pathOrganizationSid;
    private String pathUserSid;
    private User.ScimUser scimUser;
    private String ifMatch;

    public UserUpdater(String pathOrganizationSid, String pathUserSid, User.ScimUser scimUser) {
        this.pathOrganizationSid = pathOrganizationSid;
        this.pathUserSid = pathUserSid;
        this.scimUser = scimUser;
    }

    public UserUpdater setScimUser(User.ScimUser scimUser) {
        this.scimUser = scimUser;
        return this;
    }

    public UserUpdater setIfMatch(String ifMatch) {
        this.ifMatch = ifMatch;
        return this;
    }

    @Override
    public User update(BearerTokenTwilioRestClient client) {
        String path = "/Organizations/{OrganizationSid}/scim/Users/{UserSid}";
        path = path.replace("{OrganizationSid}", this.pathOrganizationSid.toString());
        path = path.replace("{UserSid}", this.pathUserSid.toString());
        path = path.replace("{ScimUser}", this.scimUser.toString());
        BearerTokenRequest request = new BearerTokenRequest(HttpMethod.PUT, Domains.PREVIEWIAM.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request, client);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("User update failed: Unable to connect to server");
        }
        if (!BearerTokenTwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return User.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(BearerTokenRequest request, BearerTokenTwilioRestClient client) {
        ObjectMapper objectMapper = client.getObjectMapper();
        if (this.scimUser != null) {
            request.setBody(User.toJson(this.scimUser, objectMapper));
        }
    }

    private void addHeaderParams(BearerTokenRequest request) {
        if (this.ifMatch != null) {
            request.addHeaderParam("If-Match", this.ifMatch);
        }
    }
}

