/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.routes.v2;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.routes.v2.PhoneNumber;

public class PhoneNumberUpdater
extends Updater<PhoneNumber> {
    private String pathPhoneNumber;
    private String voiceRegion;
    private String friendlyName;

    public PhoneNumberUpdater(String pathPhoneNumber) {
        this.pathPhoneNumber = pathPhoneNumber;
    }

    public PhoneNumberUpdater setVoiceRegion(String voiceRegion) {
        this.voiceRegion = voiceRegion;
        return this;
    }

    public PhoneNumberUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    @Override
    public PhoneNumber update(TwilioRestClient client) {
        String path = "/v2/PhoneNumbers/{PhoneNumber}";
        path = path.replace("{PhoneNumber}", this.pathPhoneNumber.toString());
        Request request = new Request(HttpMethod.POST, Domains.ROUTES.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("PhoneNumber update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return PhoneNumber.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.voiceRegion != null) {
            request.addPostParam("VoiceRegion", this.voiceRegion);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
    }
}

