/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v2.flow;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.studio.v2.flow.FlowTestUser;
import java.util.List;

public class FlowTestUserUpdater
extends Updater<FlowTestUser> {
    private String pathSid;
    private List<String> testUsers;

    public FlowTestUserUpdater(String pathSid, List<String> testUsers) {
        this.pathSid = pathSid;
        this.testUsers = testUsers;
    }

    public FlowTestUserUpdater setTestUsers(List<String> testUsers) {
        this.testUsers = testUsers;
        return this;
    }

    public FlowTestUserUpdater setTestUsers(String testUsers) {
        return this.setTestUsers(Promoter.listOfOne(testUsers));
    }

    @Override
    public FlowTestUser update(TwilioRestClient client) {
        String path = "/v2/Flows/{Sid}/TestUsers";
        path = path.replace("{Sid}", this.pathSid.toString());
        path = path.replace("{TestUsers}", this.testUsers.toString());
        Request request = new Request(HttpMethod.POST, Domains.STUDIO.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("FlowTestUser update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return FlowTestUser.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.testUsers != null) {
            for (String prop : this.testUsers) {
                request.addPostParam("TestUsers", prop);
            }
        }
    }
}

