/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v2.flow.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.studio.v2.flow.execution.ExecutionContextFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ExecutionContext
extends Resource {
    private static final long serialVersionUID = 48761390116247L;
    private final String accountSid;
    private final Map<String, Object> context;
    private final String flowSid;
    private final String executionSid;
    private final URI url;

    public static ExecutionContextFetcher fetcher(String pathFlowSid, String pathExecutionSid) {
        return new ExecutionContextFetcher(pathFlowSid, pathExecutionSid);
    }

    public static ExecutionContext fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ExecutionContext.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ExecutionContext fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ExecutionContext.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ExecutionContext(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="context") Map<String, Object> context, @JsonProperty(value="flow_sid") String flowSid, @JsonProperty(value="execution_sid") String executionSid, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.context = context;
        this.flowSid = flowSid;
        this.executionSid = executionSid;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Map<String, Object> getContext() {
        return this.context;
    }

    public final String getFlowSid() {
        return this.flowSid;
    }

    public final String getExecutionSid() {
        return this.executionSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionContext other = (ExecutionContext)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.context, other.context) && Objects.equals(this.flowSid, other.flowSid) && Objects.equals(this.executionSid, other.executionSid) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.context, this.flowSid, this.executionSid, this.url);
    }

    public String toString() {
        return "ExecutionContext(accountSid=" + this.getAccountSid() + ", context=" + this.getContext() + ", flowSid=" + this.getFlowSid() + ", executionSid=" + this.getExecutionSid() + ", url=" + this.getUrl() + ")";
    }
}

