/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.supersim.v1.Fleet;

public class FleetReader
extends Reader<Fleet> {
    private String networkAccessProfile;
    private Integer pageSize;

    public FleetReader setNetworkAccessProfile(String networkAccessProfile) {
        this.networkAccessProfile = networkAccessProfile;
        return this;
    }

    public FleetReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Fleet> read(TwilioRestClient client) {
        return new ResourceSet<Fleet>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Fleet> firstPage(TwilioRestClient client) {
        String path = "/v1/Fleets";
        Request request = new Request(HttpMethod.GET, Domains.SUPERSIM.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<Fleet> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Fleet read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("fleets", response.getContent(), Fleet.class, client.getObjectMapper());
    }

    @Override
    public Page<Fleet> previousPage(Page<Fleet> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.SUPERSIM.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Fleet> nextPage(Page<Fleet> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.SUPERSIM.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Fleet> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.networkAccessProfile != null) {
            request.addQueryParam("NetworkAccessProfile", this.networkAccessProfile);
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

