/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1.sim;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.supersim.v1.sim.BillingPeriodReader;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BillingPeriod
extends Resource {
    private static final long serialVersionUID = 154829037650501L;
    private final String sid;
    private final String accountSid;
    private final String simSid;
    private final ZonedDateTime startTime;
    private final ZonedDateTime endTime;
    private final BpType periodType;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;

    public static BillingPeriodReader reader(String pathSimSid) {
        return new BillingPeriodReader(pathSimSid);
    }

    public static BillingPeriod fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, BillingPeriod.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static BillingPeriod fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, BillingPeriod.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private BillingPeriod(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="sim_sid") String simSid, @JsonProperty(value="start_time") String startTime, @JsonProperty(value="end_time") String endTime, @JsonProperty(value="period_type") BpType periodType, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.simSid = simSid;
        this.startTime = DateConverter.iso8601DateTimeFromString(startTime);
        this.endTime = DateConverter.iso8601DateTimeFromString(endTime);
        this.periodType = periodType;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getSimSid() {
        return this.simSid;
    }

    public final ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public final ZonedDateTime getEndTime() {
        return this.endTime;
    }

    public final BpType getPeriodType() {
        return this.periodType;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillingPeriod other = (BillingPeriod)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.simSid, other.simSid) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals((Object)this.periodType, (Object)other.periodType) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.simSid, this.startTime, this.endTime, this.periodType, this.dateCreated, this.dateUpdated});
    }

    public String toString() {
        return "BillingPeriod(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", simSid=" + this.getSimSid() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", periodType=" + (Object)((Object)this.getPeriodType()) + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ")";
    }

    public static enum BpType {
        READY("ready"),
        ACTIVE("active");

        private final String value;

        private BpType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static BpType forValue(String value) {
            return (BpType)Promoter.enumFromString((String)value, (Enum[])BpType.values());
        }
    }
}

