/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.sync.v1.service.syncmap;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.sync.v1.service.syncmap.SyncMapPermissionDeleter;
import com.twilio.rest.sync.v1.service.syncmap.SyncMapPermissionFetcher;
import com.twilio.rest.sync.v1.service.syncmap.SyncMapPermissionReader;
import com.twilio.rest.sync.v1.service.syncmap.SyncMapPermissionUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SyncMapPermission
extends Resource {
    private static final long serialVersionUID = 55149075645678L;
    private final String accountSid;
    private final String serviceSid;
    private final String mapSid;
    private final String identity;
    private final Boolean read;
    private final Boolean write;
    private final Boolean manage;
    private final URI url;

    public static SyncMapPermissionDeleter deleter(String pathServiceSid, String pathMapSid, String pathIdentity) {
        return new SyncMapPermissionDeleter(pathServiceSid, pathMapSid, pathIdentity);
    }

    public static SyncMapPermissionFetcher fetcher(String pathServiceSid, String pathMapSid, String pathIdentity) {
        return new SyncMapPermissionFetcher(pathServiceSid, pathMapSid, pathIdentity);
    }

    public static SyncMapPermissionReader reader(String pathServiceSid, String pathMapSid) {
        return new SyncMapPermissionReader(pathServiceSid, pathMapSid);
    }

    public static SyncMapPermissionUpdater updater(String pathServiceSid, String pathMapSid, String pathIdentity, Boolean read, Boolean write, Boolean manage) {
        return new SyncMapPermissionUpdater(pathServiceSid, pathMapSid, pathIdentity, read, write, manage);
    }

    public static SyncMapPermission fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SyncMapPermission.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static SyncMapPermission fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SyncMapPermission.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private SyncMapPermission(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="map_sid") String mapSid, @JsonProperty(value="identity") String identity, @JsonProperty(value="read") Boolean read, @JsonProperty(value="write") Boolean write, @JsonProperty(value="manage") Boolean manage, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.mapSid = mapSid;
        this.identity = identity;
        this.read = read;
        this.write = write;
        this.manage = manage;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getMapSid() {
        return this.mapSid;
    }

    public final String getIdentity() {
        return this.identity;
    }

    public final Boolean getRead() {
        return this.read;
    }

    public final Boolean getWrite() {
        return this.write;
    }

    public final Boolean getManage() {
        return this.manage;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyncMapPermission other = (SyncMapPermission)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.mapSid, other.mapSid) && Objects.equals(this.identity, other.identity) && Objects.equals(this.read, other.read) && Objects.equals(this.write, other.write) && Objects.equals(this.manage, other.manage) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.serviceSid, this.mapSid, this.identity, this.read, this.write, this.manage, this.url);
    }

    public String toString() {
        return "SyncMapPermission(accountSid=" + this.getAccountSid() + ", serviceSid=" + this.getServiceSid() + ", mapSid=" + this.getMapSid() + ", identity=" + this.getIdentity() + ", read=" + this.getRead() + ", write=" + this.getWrite() + ", manage=" + this.getManage() + ", url=" + this.getUrl() + ")";
    }
}

