/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace.worker;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.worker.WorkersStatistics;
import java.time.ZonedDateTime;

public class WorkersStatisticsFetcher
extends Fetcher<WorkersStatistics> {
    private String pathWorkspaceSid;
    private Integer minutes;
    private ZonedDateTime startDate;
    private ZonedDateTime endDate;
    private String taskQueueSid;
    private String taskQueueName;
    private String friendlyName;
    private String taskChannel;

    public WorkersStatisticsFetcher(String pathWorkspaceSid) {
        this.pathWorkspaceSid = pathWorkspaceSid;
    }

    public WorkersStatisticsFetcher setMinutes(Integer minutes) {
        this.minutes = minutes;
        return this;
    }

    public WorkersStatisticsFetcher setStartDate(ZonedDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    public WorkersStatisticsFetcher setEndDate(ZonedDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    public WorkersStatisticsFetcher setTaskQueueSid(String taskQueueSid) {
        this.taskQueueSid = taskQueueSid;
        return this;
    }

    public WorkersStatisticsFetcher setTaskQueueName(String taskQueueName) {
        this.taskQueueName = taskQueueName;
        return this;
    }

    public WorkersStatisticsFetcher setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public WorkersStatisticsFetcher setTaskChannel(String taskChannel) {
        this.taskChannel = taskChannel;
        return this;
    }

    @Override
    public WorkersStatistics fetch(TwilioRestClient client) {
        String path = "/v1/Workspaces/{WorkspaceSid}/Workers/Statistics";
        path = path.replace("{WorkspaceSid}", this.pathWorkspaceSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.TASKROUTER.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("WorkersStatistics fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return WorkersStatistics.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.minutes != null) {
            request.addQueryParam("Minutes", this.minutes.toString());
        }
        if (this.startDate != null) {
            request.addQueryParam("StartDate", this.startDate.toInstant().toString());
        }
        if (this.endDate != null) {
            request.addQueryParam("EndDate", this.endDate.toInstant().toString());
        }
        if (this.taskQueueSid != null) {
            request.addQueryParam("TaskQueueSid", this.taskQueueSid);
        }
        if (this.taskQueueName != null) {
            request.addQueryParam("TaskQueueName", this.taskQueueName);
        }
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        if (this.taskChannel != null) {
            request.addQueryParam("TaskChannel", this.taskChannel);
        }
    }
}

