/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trunking.v1.trunk;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.trunking.v1.trunk.IpAccessControlList;

public class IpAccessControlListReader
extends Reader<IpAccessControlList> {
    private String pathTrunkSid;
    private Integer pageSize;

    public IpAccessControlListReader(String pathTrunkSid) {
        this.pathTrunkSid = pathTrunkSid;
    }

    public IpAccessControlListReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<IpAccessControlList> read(TwilioRestClient client) {
        return new ResourceSet<IpAccessControlList>(this, client, this.firstPage(client));
    }

    @Override
    public Page<IpAccessControlList> firstPage(TwilioRestClient client) {
        String path = "/v1/Trunks/{TrunkSid}/IpAccessControlLists";
        path = path.replace("{TrunkSid}", this.pathTrunkSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.TRUNKING.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<IpAccessControlList> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("IpAccessControlList read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("ip_access_control_lists", response.getContent(), IpAccessControlList.class, client.getObjectMapper());
    }

    @Override
    public Page<IpAccessControlList> previousPage(Page<IpAccessControlList> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.TRUNKING.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<IpAccessControlList> nextPage(Page<IpAccessControlList> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.TRUNKING.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<IpAccessControlList> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

