/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trusthub.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.trusthub.v1.ComplianceRegistrationInquiries;

public class ComplianceRegistrationInquiriesUpdater
extends Updater<ComplianceRegistrationInquiries> {
    private String pathRegistrationId;
    private Boolean isIsvEmbed;
    private String themeSetId;

    public ComplianceRegistrationInquiriesUpdater(String pathRegistrationId) {
        this.pathRegistrationId = pathRegistrationId;
    }

    public ComplianceRegistrationInquiriesUpdater setIsIsvEmbed(Boolean isIsvEmbed) {
        this.isIsvEmbed = isIsvEmbed;
        return this;
    }

    public ComplianceRegistrationInquiriesUpdater setThemeSetId(String themeSetId) {
        this.themeSetId = themeSetId;
        return this;
    }

    @Override
    public ComplianceRegistrationInquiries update(TwilioRestClient client) {
        String path = "/v1/ComplianceInquiries/Registration/{RegistrationId}/RegulatoryCompliance/GB/Initialize";
        path = path.replace("{RegistrationId}", this.pathRegistrationId.toString());
        Request request = new Request(HttpMethod.POST, Domains.TRUSTHUB.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ComplianceRegistrationInquiries update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return ComplianceRegistrationInquiries.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.isIsvEmbed != null) {
            request.addPostParam("IsIsvEmbed", this.isIsvEmbed.toString());
        }
        if (this.themeSetId != null) {
            request.addPostParam("ThemeSetId", this.themeSetId);
        }
    }
}

