/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trusthub.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.trusthub.v1.TrustProductsCreator;
import com.twilio.rest.trusthub.v1.TrustProductsDeleter;
import com.twilio.rest.trusthub.v1.TrustProductsFetcher;
import com.twilio.rest.trusthub.v1.TrustProductsReader;
import com.twilio.rest.trusthub.v1.TrustProductsUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TrustProducts
extends Resource {
    private static final long serialVersionUID = 79201442410217L;
    private final String sid;
    private final String accountSid;
    private final String policySid;
    private final String friendlyName;
    private final Status status;
    private final ZonedDateTime validUntil;
    private final String email;
    private final URI statusCallback;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;
    private final Map<String, String> links;
    private final List<Map<String, Object>> errors;

    public static TrustProductsCreator creator(String friendlyName, String email, String policySid) {
        return new TrustProductsCreator(friendlyName, email, policySid);
    }

    public static TrustProductsDeleter deleter(String pathSid) {
        return new TrustProductsDeleter(pathSid);
    }

    public static TrustProductsFetcher fetcher(String pathSid) {
        return new TrustProductsFetcher(pathSid);
    }

    public static TrustProductsReader reader() {
        return new TrustProductsReader();
    }

    public static TrustProductsUpdater updater(String pathSid) {
        return new TrustProductsUpdater(pathSid);
    }

    public static TrustProducts fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, TrustProducts.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static TrustProducts fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, TrustProducts.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private TrustProducts(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="policy_sid") String policySid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="status") Status status, @JsonProperty(value="valid_until") String validUntil, @JsonProperty(value="email") String email, @JsonProperty(value="status_callback") URI statusCallback, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links, @JsonProperty(value="errors") List<Map<String, Object>> errors) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.policySid = policySid;
        this.friendlyName = friendlyName;
        this.status = status;
        this.validUntil = DateConverter.iso8601DateTimeFromString(validUntil);
        this.email = email;
        this.statusCallback = statusCallback;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.links = links;
        this.errors = errors;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getPolicySid() {
        return this.policySid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final ZonedDateTime getValidUntil() {
        return this.validUntil;
    }

    public final String getEmail() {
        return this.email;
    }

    public final URI getStatusCallback() {
        return this.statusCallback;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public final List<Map<String, Object>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrustProducts other = (TrustProducts)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.policySid, other.policySid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.validUntil, other.validUntil) && Objects.equals(this.email, other.email) && Objects.equals(this.statusCallback, other.statusCallback) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links) && Objects.equals(this.errors, other.errors);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.policySid, this.friendlyName, this.status, this.validUntil, this.email, this.statusCallback, this.dateCreated, this.dateUpdated, this.url, this.links, this.errors});
    }

    public String toString() {
        return "TrustProducts(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", policySid=" + this.getPolicySid() + ", friendlyName=" + this.getFriendlyName() + ", status=" + (Object)((Object)this.getStatus()) + ", validUntil=" + this.getValidUntil() + ", email=" + this.getEmail() + ", statusCallback=" + this.getStatusCallback() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ", links=" + this.getLinks() + ", errors=" + this.getErrors() + ")";
    }

    public static enum Status {
        DRAFT("draft"),
        PENDING_REVIEW("pending-review"),
        IN_REVIEW("in-review"),
        TWILIO_REJECTED("twilio-rejected"),
        TWILIO_APPROVED("twilio-approved");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

