/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.Safelist;

public class SafelistFetcher
extends Fetcher<Safelist> {
    private String pathPhoneNumber;

    public SafelistFetcher(String pathPhoneNumber) {
        this.pathPhoneNumber = pathPhoneNumber;
    }

    @Override
    public Safelist fetch(TwilioRestClient client) {
        String path = "/v2/SafeList/Numbers/{PhoneNumber}";
        path = path.replace("{PhoneNumber}", this.pathPhoneNumber.toString());
        Request request = new Request(HttpMethod.GET, Domains.VERIFY.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Safelist fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Safelist.fromJson(response.getStream(), client.getObjectMapper());
    }
}

