/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.verify.v2.service.AccessTokenCreator;
import com.twilio.rest.verify.v2.service.AccessTokenFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AccessToken
extends Resource {
    private static final long serialVersionUID = 272179273532388L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final String entityIdentity;
    private final FactorTypes factorType;
    private final String factorFriendlyName;
    private final String token;
    private final URI url;
    private final Integer ttl;
    private final ZonedDateTime dateCreated;

    public static AccessTokenCreator creator(String pathServiceSid, String identity, FactorTypes factorType) {
        return new AccessTokenCreator(pathServiceSid, identity, factorType);
    }

    public static AccessTokenFetcher fetcher(String pathServiceSid, String pathSid) {
        return new AccessTokenFetcher(pathServiceSid, pathSid);
    }

    public static AccessToken fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, AccessToken.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static AccessToken fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, AccessToken.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private AccessToken(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="entity_identity") String entityIdentity, @JsonProperty(value="factor_type") FactorTypes factorType, @JsonProperty(value="factor_friendly_name") String factorFriendlyName, @JsonProperty(value="token") String token, @JsonProperty(value="url") URI url, @JsonProperty(value="ttl") Integer ttl, @JsonProperty(value="date_created") String dateCreated) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.entityIdentity = entityIdentity;
        this.factorType = factorType;
        this.factorFriendlyName = factorFriendlyName;
        this.token = token;
        this.url = url;
        this.ttl = ttl;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getEntityIdentity() {
        return this.entityIdentity;
    }

    public final FactorTypes getFactorType() {
        return this.factorType;
    }

    public final String getFactorFriendlyName() {
        return this.factorFriendlyName;
    }

    public final String getToken() {
        return this.token;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Integer getTtl() {
        return this.ttl;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessToken other = (AccessToken)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.entityIdentity, other.entityIdentity) && Objects.equals((Object)this.factorType, (Object)other.factorType) && Objects.equals(this.factorFriendlyName, other.factorFriendlyName) && Objects.equals(this.token, other.token) && Objects.equals(this.url, other.url) && Objects.equals(this.ttl, other.ttl) && Objects.equals(this.dateCreated, other.dateCreated);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.serviceSid, this.entityIdentity, this.factorType, this.factorFriendlyName, this.token, this.url, this.ttl, this.dateCreated});
    }

    public String toString() {
        return "AccessToken(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", serviceSid=" + this.getServiceSid() + ", entityIdentity=" + this.getEntityIdentity() + ", factorType=" + (Object)((Object)this.getFactorType()) + ", factorFriendlyName=" + this.getFactorFriendlyName() + ", token=" + this.getToken() + ", url=" + this.getUrl() + ", ttl=" + this.getTtl() + ", dateCreated=" + this.getDateCreated() + ")";
    }

    public static enum FactorTypes {
        PUSH("push");

        private final String value;

        private FactorTypes(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static FactorTypes forValue(String value) {
            return (FactorTypes)Promoter.enumFromString((String)value, (Enum[])FactorTypes.values());
        }
    }
}

