/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.service.MessagingConfiguration;

public class MessagingConfigurationCreator
extends Creator<MessagingConfiguration> {
    private String pathServiceSid;
    private String country;
    private String messagingServiceSid;

    public MessagingConfigurationCreator(String pathServiceSid, String country, String messagingServiceSid) {
        this.pathServiceSid = pathServiceSid;
        this.country = country;
        this.messagingServiceSid = messagingServiceSid;
    }

    public MessagingConfigurationCreator setCountry(String country) {
        this.country = country;
        return this;
    }

    public MessagingConfigurationCreator setMessagingServiceSid(String messagingServiceSid) {
        this.messagingServiceSid = messagingServiceSid;
        return this;
    }

    @Override
    public MessagingConfiguration create(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/MessagingConfigurations";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{Country}", this.country.toString());
        path = path.replace("{MessagingServiceSid}", this.messagingServiceSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.VERIFY.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("MessagingConfiguration creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return MessagingConfiguration.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.country != null) {
            request.addPostParam("Country", this.country);
        }
        if (this.messagingServiceSid != null) {
            request.addPostParam("MessagingServiceSid", this.messagingServiceSid);
        }
    }
}

