/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service.entity;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.service.entity.Factor;

public class FactorUpdater
extends Updater<Factor> {
    private String pathServiceSid;
    private String pathIdentity;
    private String pathSid;
    private String authPayload;
    private String friendlyName;
    private String configNotificationToken;
    private String configSdkVersion;
    private Integer configTimeStep;
    private Integer configSkew;
    private Integer configCodeLength;
    private Factor.TotpAlgorithms configAlg;
    private String configNotificationPlatform;

    public FactorUpdater(String pathServiceSid, String pathIdentity, String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathIdentity = pathIdentity;
        this.pathSid = pathSid;
    }

    public FactorUpdater setAuthPayload(String authPayload) {
        this.authPayload = authPayload;
        return this;
    }

    public FactorUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public FactorUpdater setConfigNotificationToken(String configNotificationToken) {
        this.configNotificationToken = configNotificationToken;
        return this;
    }

    public FactorUpdater setConfigSdkVersion(String configSdkVersion) {
        this.configSdkVersion = configSdkVersion;
        return this;
    }

    public FactorUpdater setConfigTimeStep(Integer configTimeStep) {
        this.configTimeStep = configTimeStep;
        return this;
    }

    public FactorUpdater setConfigSkew(Integer configSkew) {
        this.configSkew = configSkew;
        return this;
    }

    public FactorUpdater setConfigCodeLength(Integer configCodeLength) {
        this.configCodeLength = configCodeLength;
        return this;
    }

    public FactorUpdater setConfigAlg(Factor.TotpAlgorithms configAlg) {
        this.configAlg = configAlg;
        return this;
    }

    public FactorUpdater setConfigNotificationPlatform(String configNotificationPlatform) {
        this.configNotificationPlatform = configNotificationPlatform;
        return this;
    }

    @Override
    public Factor update(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/Entities/{Identity}/Factors/{Sid}";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{Identity}", this.pathIdentity.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.VERIFY.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Factor update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Factor.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.authPayload != null) {
            request.addPostParam("AuthPayload", this.authPayload);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.configNotificationToken != null) {
            request.addPostParam("Config.NotificationToken", this.configNotificationToken);
        }
        if (this.configSdkVersion != null) {
            request.addPostParam("Config.SdkVersion", this.configSdkVersion);
        }
        if (this.configTimeStep != null) {
            request.addPostParam("Config.TimeStep", this.configTimeStep.toString());
        }
        if (this.configSkew != null) {
            request.addPostParam("Config.Skew", this.configSkew.toString());
        }
        if (this.configCodeLength != null) {
            request.addPostParam("Config.CodeLength", this.configCodeLength.toString());
        }
        if (this.configAlg != null) {
            request.addPostParam("Config.Alg", this.configAlg.toString());
        }
        if (this.configNotificationPlatform != null) {
            request.addPostParam("Config.NotificationPlatform", this.configNotificationPlatform);
        }
    }
}

