/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.verify.v2.service.entity.NewFactorCreator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NewFactor
extends Resource {
    private static final long serialVersionUID = 115808224888150L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final String entitySid;
    private final String identity;
    private final Map<String, Object> binding;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String friendlyName;
    private final FactorStatuses status;
    private final FactorTypes factorType;
    private final Map<String, Object> config;
    private final Map<String, Object> metadata;
    private final URI url;

    public static NewFactorCreator creator(String pathServiceSid, String pathIdentity, String friendlyName, FactorTypes factorType) {
        return new NewFactorCreator(pathServiceSid, pathIdentity, friendlyName, factorType);
    }

    public static NewFactor fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, NewFactor.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static NewFactor fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, NewFactor.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private NewFactor(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="entity_sid") String entitySid, @JsonProperty(value="identity") String identity, @JsonProperty(value="binding") Map<String, Object> binding, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="status") FactorStatuses status, @JsonProperty(value="factor_type") FactorTypes factorType, @JsonProperty(value="config") Map<String, Object> config, @JsonProperty(value="metadata") Map<String, Object> metadata, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.entitySid = entitySid;
        this.identity = identity;
        this.binding = binding;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.status = status;
        this.factorType = factorType;
        this.config = config;
        this.metadata = metadata;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getEntitySid() {
        return this.entitySid;
    }

    public final String getIdentity() {
        return this.identity;
    }

    public final Map<String, Object> getBinding() {
        return this.binding;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final FactorStatuses getStatus() {
        return this.status;
    }

    public final FactorTypes getFactorType() {
        return this.factorType;
    }

    public final Map<String, Object> getConfig() {
        return this.config;
    }

    public final Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewFactor other = (NewFactor)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.entitySid, other.entitySid) && Objects.equals(this.identity, other.identity) && Objects.equals(this.binding, other.binding) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.factorType, (Object)other.factorType) && Objects.equals(this.config, other.config) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.serviceSid, this.entitySid, this.identity, this.binding, this.dateCreated, this.dateUpdated, this.friendlyName, this.status, this.factorType, this.config, this.metadata, this.url});
    }

    public String toString() {
        return "NewFactor(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", serviceSid=" + this.getServiceSid() + ", entitySid=" + this.getEntitySid() + ", identity=" + this.getIdentity() + ", binding=" + this.getBinding() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", friendlyName=" + this.getFriendlyName() + ", status=" + (Object)((Object)this.getStatus()) + ", factorType=" + (Object)((Object)this.getFactorType()) + ", config=" + this.getConfig() + ", metadata=" + this.getMetadata() + ", url=" + this.getUrl() + ")";
    }

    public static enum FactorStatuses {
        UNVERIFIED("unverified"),
        VERIFIED("verified");

        private final String value;

        private FactorStatuses(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static FactorStatuses forValue(String value) {
            return (FactorStatuses)Promoter.enumFromString((String)value, (Enum[])FactorStatuses.values());
        }
    }

    public static enum NotificationPlatforms {
        APN("apn"),
        FCM("fcm"),
        NONE("none");

        private final String value;

        private NotificationPlatforms(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static NotificationPlatforms forValue(String value) {
            return (NotificationPlatforms)Promoter.enumFromString((String)value, (Enum[])NotificationPlatforms.values());
        }
    }

    public static enum FactorTypes {
        PUSH("push"),
        TOTP("totp");

        private final String value;

        private FactorTypes(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static FactorTypes forValue(String value) {
            return (FactorTypes)Promoter.enumFromString((String)value, (Enum[])FactorTypes.values());
        }
    }

    public static enum TotpAlgorithms {
        SHA1("sha1"),
        SHA256("sha256"),
        SHA512("sha512");

        private final String value;

        private TotpAlgorithms(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static TotpAlgorithms forValue(String value) {
            return (TotpAlgorithms)Promoter.enumFromString((String)value, (Enum[])TotpAlgorithms.values());
        }
    }
}

