/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service.entity.challenge;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.verify.v2.service.entity.challenge.NotificationCreator;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Notification
extends Resource {
    private static final long serialVersionUID = 216794200802882L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final String entitySid;
    private final String identity;
    private final String challengeSid;
    private final String priority;
    private final Integer ttl;
    private final ZonedDateTime dateCreated;

    public static NotificationCreator creator(String pathServiceSid, String pathIdentity, String pathChallengeSid) {
        return new NotificationCreator(pathServiceSid, pathIdentity, pathChallengeSid);
    }

    public static Notification fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Notification.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Notification fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Notification.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Notification(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="entity_sid") String entitySid, @JsonProperty(value="identity") String identity, @JsonProperty(value="challenge_sid") String challengeSid, @JsonProperty(value="priority") String priority, @JsonProperty(value="ttl") Integer ttl, @JsonProperty(value="date_created") String dateCreated) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.entitySid = entitySid;
        this.identity = identity;
        this.challengeSid = challengeSid;
        this.priority = priority;
        this.ttl = ttl;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getEntitySid() {
        return this.entitySid;
    }

    public final String getIdentity() {
        return this.identity;
    }

    public final String getChallengeSid() {
        return this.challengeSid;
    }

    public final String getPriority() {
        return this.priority;
    }

    public final Integer getTtl() {
        return this.ttl;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notification other = (Notification)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.entitySid, other.entitySid) && Objects.equals(this.identity, other.identity) && Objects.equals(this.challengeSid, other.challengeSid) && Objects.equals(this.priority, other.priority) && Objects.equals(this.ttl, other.ttl) && Objects.equals(this.dateCreated, other.dateCreated);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.serviceSid, this.entitySid, this.identity, this.challengeSid, this.priority, this.ttl, this.dateCreated);
    }

    public String toString() {
        return "Notification(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", serviceSid=" + this.getServiceSid() + ", entitySid=" + this.getEntitySid() + ", identity=" + this.getIdentity() + ", challengeSid=" + this.getChallengeSid() + ", priority=" + this.getPriority() + ", ttl=" + this.getTtl() + ", dateCreated=" + this.getDateCreated() + ")";
    }
}

