/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.video.v1.Composition;
import java.time.ZonedDateTime;

public class CompositionReader
extends Reader<Composition> {
    private Composition.Status status;
    private ZonedDateTime dateCreatedAfter;
    private ZonedDateTime dateCreatedBefore;
    private String roomSid;
    private Integer pageSize;

    public CompositionReader setStatus(Composition.Status status) {
        this.status = status;
        return this;
    }

    public CompositionReader setDateCreatedAfter(ZonedDateTime dateCreatedAfter) {
        this.dateCreatedAfter = dateCreatedAfter;
        return this;
    }

    public CompositionReader setDateCreatedBefore(ZonedDateTime dateCreatedBefore) {
        this.dateCreatedBefore = dateCreatedBefore;
        return this;
    }

    public CompositionReader setRoomSid(String roomSid) {
        this.roomSid = roomSid;
        return this;
    }

    public CompositionReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Composition> read(TwilioRestClient client) {
        return new ResourceSet<Composition>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Composition> firstPage(TwilioRestClient client) {
        String path = "/v1/Compositions";
        Request request = new Request(HttpMethod.GET, Domains.VIDEO.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<Composition> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Composition read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("compositions", response.getContent(), Composition.class, client.getObjectMapper());
    }

    @Override
    public Page<Composition> previousPage(Page<Composition> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.VIDEO.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Composition> nextPage(Page<Composition> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.VIDEO.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Composition> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.status != null) {
            request.addQueryParam("Status", this.status.toString());
        }
        if (this.dateCreatedAfter != null) {
            request.addQueryParam("DateCreatedAfter", this.dateCreatedAfter.toInstant().toString());
        }
        if (this.dateCreatedBefore != null) {
            request.addQueryParam("DateCreatedBefore", this.dateCreatedBefore.toInstant().toString());
        }
        if (this.roomSid != null) {
            request.addQueryParam("RoomSid", this.roomSid);
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

