/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.voice.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.voice.v1.SourceIpMapping;

public class SourceIpMappingUpdater
extends Updater<SourceIpMapping> {
    private String pathSid;
    private String sipDomainSid;

    public SourceIpMappingUpdater(String pathSid, String sipDomainSid) {
        this.pathSid = pathSid;
        this.sipDomainSid = sipDomainSid;
    }

    public SourceIpMappingUpdater setSipDomainSid(String sipDomainSid) {
        this.sipDomainSid = sipDomainSid;
        return this;
    }

    @Override
    public SourceIpMapping update(TwilioRestClient client) {
        String path = "/v1/SourceIpMappings/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        path = path.replace("{SipDomainSid}", this.sipDomainSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.VOICE.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SourceIpMapping update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return SourceIpMapping.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.sipDomainSid != null) {
            request.addPostParam("SipDomainSid", this.sipDomainSid);
        }
    }
}

