/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.voice.v1.dialingpermissions;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.voice.v1.dialingpermissions.BulkCountryUpdate;

public class BulkCountryUpdateCreator
extends Creator<BulkCountryUpdate> {
    private String updateRequest;

    public BulkCountryUpdateCreator(String updateRequest) {
        this.updateRequest = updateRequest;
    }

    public BulkCountryUpdateCreator setUpdateRequest(String updateRequest) {
        this.updateRequest = updateRequest;
        return this;
    }

    @Override
    public BulkCountryUpdate create(TwilioRestClient client) {
        String path = "/v1/DialingPermissions/BulkCountryUpdates";
        path = path.replace("{UpdateRequest}", this.updateRequest.toString());
        Request request = new Request(HttpMethod.POST, Domains.VOICE.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("BulkCountryUpdate creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return BulkCountryUpdate.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.updateRequest != null) {
            request.addPostParam("UpdateRequest", this.updateRequest);
        }
    }
}

