/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.wireless.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.wireless.v1.CommandCreator;
import com.twilio.rest.wireless.v1.CommandDeleter;
import com.twilio.rest.wireless.v1.CommandFetcher;
import com.twilio.rest.wireless.v1.CommandReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Command
extends Resource {
    private static final long serialVersionUID = 179149511827589L;
    private final String sid;
    private final String accountSid;
    private final String simSid;
    private final String command;
    private final CommandMode commandMode;
    private final Transport transport;
    private final Boolean deliveryReceiptRequested;
    private final Status status;
    private final Direction direction;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;

    public static CommandCreator creator(String command) {
        return new CommandCreator(command);
    }

    public static CommandDeleter deleter(String pathSid) {
        return new CommandDeleter(pathSid);
    }

    public static CommandFetcher fetcher(String pathSid) {
        return new CommandFetcher(pathSid);
    }

    public static CommandReader reader() {
        return new CommandReader();
    }

    public static Command fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Command.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Command fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Command.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Command(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="sim_sid") String simSid, @JsonProperty(value="command") String command, @JsonProperty(value="command_mode") CommandMode commandMode, @JsonProperty(value="transport") Transport transport, @JsonProperty(value="delivery_receipt_requested") Boolean deliveryReceiptRequested, @JsonProperty(value="status") Status status, @JsonProperty(value="direction") Direction direction, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.simSid = simSid;
        this.command = command;
        this.commandMode = commandMode;
        this.transport = transport;
        this.deliveryReceiptRequested = deliveryReceiptRequested;
        this.status = status;
        this.direction = direction;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getSimSid() {
        return this.simSid;
    }

    public final String getCommand() {
        return this.command;
    }

    public final CommandMode getCommandMode() {
        return this.commandMode;
    }

    public final Transport getTransport() {
        return this.transport;
    }

    public final Boolean getDeliveryReceiptRequested() {
        return this.deliveryReceiptRequested;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final Direction getDirection() {
        return this.direction;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Command other = (Command)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.simSid, other.simSid) && Objects.equals(this.command, other.command) && Objects.equals((Object)this.commandMode, (Object)other.commandMode) && Objects.equals((Object)this.transport, (Object)other.transport) && Objects.equals(this.deliveryReceiptRequested, other.deliveryReceiptRequested) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.direction, (Object)other.direction) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.simSid, this.command, this.commandMode, this.transport, this.deliveryReceiptRequested, this.status, this.direction, this.dateCreated, this.dateUpdated, this.url});
    }

    public String toString() {
        return "Command(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", simSid=" + this.getSimSid() + ", command=" + this.getCommand() + ", commandMode=" + (Object)((Object)this.getCommandMode()) + ", transport=" + (Object)((Object)this.getTransport()) + ", deliveryReceiptRequested=" + this.getDeliveryReceiptRequested() + ", status=" + (Object)((Object)this.getStatus()) + ", direction=" + (Object)((Object)this.getDirection()) + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ")";
    }

    public static enum Transport {
        SMS("sms"),
        IP("ip");

        private final String value;

        private Transport(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Transport forValue(String value) {
            return (Transport)Promoter.enumFromString((String)value, (Enum[])Transport.values());
        }
    }

    public static enum CommandMode {
        TEXT("text"),
        BINARY("binary");

        private final String value;

        private CommandMode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static CommandMode forValue(String value) {
            return (CommandMode)Promoter.enumFromString((String)value, (Enum[])CommandMode.values());
        }
    }

    public static enum Direction {
        FROM_SIM("from_sim"),
        TO_SIM("to_sim");

        private final String value;

        private Direction(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Direction forValue(String value) {
            return (Direction)Promoter.enumFromString((String)value, (Enum[])Direction.values());
        }
    }

    public static enum Status {
        QUEUED("queued"),
        SENT("sent"),
        DELIVERED("delivered"),
        RECEIVED("received"),
        FAILED("failed");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

