/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.wireless.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.wireless.v1.UsageRecord;
import java.time.ZonedDateTime;

public class UsageRecordReader
extends Reader<UsageRecord> {
    private ZonedDateTime end;
    private ZonedDateTime start;
    private UsageRecord.Granularity granularity;
    private Integer pageSize;

    public UsageRecordReader setEnd(ZonedDateTime end) {
        this.end = end;
        return this;
    }

    public UsageRecordReader setStart(ZonedDateTime start) {
        this.start = start;
        return this;
    }

    public UsageRecordReader setGranularity(UsageRecord.Granularity granularity) {
        this.granularity = granularity;
        return this;
    }

    public UsageRecordReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<UsageRecord> read(TwilioRestClient client) {
        return new ResourceSet<UsageRecord>(this, client, this.firstPage(client));
    }

    @Override
    public Page<UsageRecord> firstPage(TwilioRestClient client) {
        String path = "/v1/UsageRecords";
        Request request = new Request(HttpMethod.GET, Domains.WIRELESS.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<UsageRecord> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UsageRecord read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("usage_records", response.getContent(), UsageRecord.class, client.getObjectMapper());
    }

    @Override
    public Page<UsageRecord> previousPage(Page<UsageRecord> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.WIRELESS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<UsageRecord> nextPage(Page<UsageRecord> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.WIRELESS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<UsageRecord> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.end != null) {
            request.addQueryParam("End", this.end.toInstant().toString());
        }
        if (this.start != null) {
            request.addQueryParam("Start", this.start.toInstant().toString());
        }
        if (this.granularity != null) {
            request.addQueryParam("Granularity", this.granularity.toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

