/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.taskrouter;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.taskrouter.TaskRouterResource;
import java.io.IOException;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class WorkflowRuleTarget
extends TaskRouterResource {
    @JsonProperty(value="queue")
    private final String queue;
    @JsonProperty(value="expression")
    private final String expression;
    @JsonProperty(value="priority")
    private final Integer priority;
    @JsonProperty(value="timeout")
    private final Integer timeout;
    @JsonProperty(value="order_by")
    private final String orderBy;
    @JsonProperty(value="skip_if")
    private final String skipIf;
    @JsonProperty(value="known_worker_sid")
    private final String knownWorkerSid;
    @JsonProperty(value="known_worker_friendly_name")
    private final String knownWorkerFriendlyName;

    @JsonCreator
    private WorkflowRuleTarget(@JsonProperty(value="queue") String queue, @JsonProperty(value="expression") String expression, @JsonProperty(value="priority") Integer priority, @JsonProperty(value="timeout") Integer timeout, @JsonProperty(value="order_by") String orderBy, @JsonProperty(value="skip_if") String skipIf, @JsonProperty(value="known_worker_sid") String knownWorkerSid, @JsonProperty(value="known_worker_friendly_name") String knownWorkerFriendlyName) {
        this.queue = queue;
        this.expression = expression;
        this.priority = priority;
        this.timeout = timeout;
        this.orderBy = orderBy;
        this.skipIf = skipIf;
        this.knownWorkerSid = knownWorkerSid;
        this.knownWorkerFriendlyName = knownWorkerFriendlyName;
    }

    private WorkflowRuleTarget(Builder b) throws IllegalArgumentException {
        this.queue = b.queue;
        this.expression = b.expression;
        this.priority = b.priority;
        this.timeout = b.timeout;
        this.orderBy = b.orderBy;
        this.skipIf = b.skipIf;
        this.knownWorkerSid = b.knownWorkerSid;
        this.knownWorkerFriendlyName = b.knownWorkerFriendlyName;
    }

    public String getQueue() {
        return this.queue;
    }

    public String getExpression() {
        return this.expression;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public String getSkipIf() {
        return this.skipIf;
    }

    public String getKnownWorkerSid() {
        return this.knownWorkerSid;
    }

    public String getKnownWorkerFriendlyName() {
        return this.knownWorkerFriendlyName;
    }

    public static WorkflowRuleTarget fromJson(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readValue(json, WorkflowRuleTarget.class);
    }

    public String toString() {
        return "WorkflowRuleTarget(queue=" + this.getQueue() + ", expression=" + this.getExpression() + ", priority=" + this.getPriority() + ", timeout=" + this.getTimeout() + ", orderBy=" + this.getOrderBy() + ", skipIf=" + this.getSkipIf() + ", knownWorkerSid=" + this.getKnownWorkerSid() + ", knownWorkerFriendlyName=" + this.getKnownWorkerFriendlyName() + ")";
    }

    public static class Builder {
        private String queue;
        private String expression;
        private Integer priority;
        private Integer timeout;
        private String orderBy;
        private String skipIf;
        private String knownWorkerSid;
        private String knownWorkerFriendlyName;

        public Builder(String queue) {
            this.queue = queue;
        }

        public Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder orderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public Builder skipIf(String skipIf) {
            this.skipIf = skipIf;
            return this;
        }

        public Builder knownWorkerSid(String knownWorkerSid) {
            this.knownWorkerSid = knownWorkerSid;
            return this;
        }

        public Builder knownWorkerFriendlyName(String knownWorkerFriendlyName) {
            this.knownWorkerFriendlyName = knownWorkerFriendlyName;
            return this;
        }

        public WorkflowRuleTarget build() {
            return new WorkflowRuleTarget(this);
        }
    }
}

