/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml;

import com.ctc.wstx.stax.WstxInputFactory;
import com.ctc.wstx.stax.WstxOutputFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlText;
import com.twilio.twiml.GenericNode;
import com.twilio.twiml.Text;
import com.twilio.twiml.TwiMLException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class TwiML {
    private final String tagName;
    private final Builder builder;
    private static final Map<String, String> attrNameMapper = Collections.singletonMap("for_", "for");
    private static final Logger logger = LoggerFactory.getLogger(TwiML.class);

    protected TwiML(String tagName, Builder builder) {
        this.tagName = tagName;
        this.builder = builder;
    }

    protected String getElementBody() {
        return null;
    }

    protected Map<String, String> getElementAttributes() {
        return new HashMap<String, String>();
    }

    public String getTagName() {
        return this.tagName;
    }

    public List<TwiML> getChildren() {
        return this.builder.children;
    }

    public Map<String, String> getOptions() {
        return this.builder.options;
    }

    private String getTransformedAttrName(String attrName) {
        return attrNameMapper.containsKey(attrName) ? attrNameMapper.get(attrName) : attrName;
    }

    protected Node buildXmlElement(Document parentDoc) {
        Element node = parentDoc.createElement(this.getTagName());
        String body = this.getElementBody();
        if (body != null) {
            node.appendChild(parentDoc.createTextNode(body));
        }
        for (Map.Entry<String, String> entry : this.getElementAttributes().entrySet()) {
            node.setAttribute(this.getTransformedAttrName(entry.getKey()), entry.getValue());
        }
        for (TwiML twiML : this.getChildren()) {
            node.appendChild(twiML.buildXmlElement(parentDoc));
        }
        for (Map.Entry entry : this.getOptions().entrySet()) {
            node.setAttribute((String)entry.getKey(), (String)entry.getValue());
        }
        return node;
    }

    public String toXml() throws TwiMLException {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            doc.setXmlStandalone(true);
            doc.appendChild(this.buildXmlElement(doc));
            TransformerFactory tFact = TransformerFactory.newInstance();
            try {
                tFact.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                tFact.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            }
            catch (IllegalArgumentException e) {
                logger.debug("XML TransformerFactory does not support attribute: %s", (Object)e.getMessage());
            }
            Transformer transformer = tFact.newTransformer();
            transformer.setOutputProperty("indent", "no");
            DOMSource source = new DOMSource(doc);
            StreamResult output = new StreamResult(new StringWriter());
            transformer.transform(source, output);
            return output.getWriter().toString().trim();
        }
        catch (TransformerException te) {
            throw new TwiMLException("Exception serializing TwiML: " + te.getMessage());
        }
        catch (Exception e) {
            throw new TwiMLException("Unhandled exception: " + e.getMessage());
        }
    }

    public String toUrl() throws TwiMLException {
        try {
            return URLEncoder.encode(this.toXml(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new TwiMLException(e.getMessage());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TwiML twiml = (TwiML)o;
        return Objects.equals(this.getTagName(), twiml.getTagName()) && Objects.equals(this.getElementBody(), twiml.getElementBody()) && Objects.equals(this.getElementAttributes(), twiml.getElementAttributes()) && Objects.equals(this.getOptions(), twiml.getOptions()) && Objects.equals(this.getChildren(), twiml.getChildren());
    }

    public int hashCode() {
        return Objects.hash(this.getTagName(), this.getElementBody(), this.getElementAttributes(), this.getChildren(), this.getOptions());
    }

    public String toString() {
        return "TwiML(tagName=" + this.getTagName() + ", builder=" + this.builder + ")";
    }

    public static class Builder<T extends Builder<T>> {
        private static final XMLInputFactory XML_INPUT_FACTORY = new WstxInputFactory();
        protected static final ObjectMapper OBJECT_MAPPER;
        protected Map<String, String> options = new HashMap<String, String>();
        protected List<TwiML> children = new ArrayList<TwiML>();

        public T option(String key, String value) {
            this.options.put(key, value);
            return (T)this;
        }

        @JacksonXmlText
        public T addText(String text) {
            this.children.add(new Text(text));
            return (T)this;
        }

        public T addChild(GenericNode node) {
            this.children.add(node);
            return (T)this;
        }

        static {
            XML_INPUT_FACTORY.setProperty("javax.xml.stream.isNamespaceAware", false);
            XML_INPUT_FACTORY.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            XML_INPUT_FACTORY.setProperty("javax.xml.stream.supportDTD", false);
            OBJECT_MAPPER = new XmlMapper(new XmlFactory(XML_INPUT_FACTORY, new WstxOutputFactory())).configure(DeserializationFeature.READ_ENUMS_USING_TO_STRING, true).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        }
    }
}

