/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.converter.Promoter;
import com.twilio.http.HttpMethod;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;
import com.twilio.twiml.voice.Pause;
import com.twilio.twiml.voice.Play;
import com.twilio.twiml.voice.Say;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public class Gather
extends TwiML {
    private final List<Input> input;
    private final URI action;
    private final HttpMethod method;
    private final Integer timeout;
    private final String speechTimeout;
    private final Integer maxSpeechTime;
    private final Boolean profanityFilter;
    private final String finishOnKey;
    private final Integer numDigits;
    private final URI partialResultCallback;
    private final HttpMethod partialResultCallbackMethod;
    private final Language language;
    private final String hints;
    private final Boolean bargeIn;
    private final Boolean debug;
    private final Boolean actionOnEmptyResult;
    private final SpeechModel speechModel;
    private final Boolean enhanced;

    private Gather() {
        this(new Builder());
    }

    private Gather(Builder b) {
        super("Gather", b);
        this.input = b.input;
        this.action = b.action;
        this.method = b.method;
        this.timeout = b.timeout;
        this.speechTimeout = b.speechTimeout;
        this.maxSpeechTime = b.maxSpeechTime;
        this.profanityFilter = b.profanityFilter;
        this.finishOnKey = b.finishOnKey;
        this.numDigits = b.numDigits;
        this.partialResultCallback = b.partialResultCallback;
        this.partialResultCallbackMethod = b.partialResultCallbackMethod;
        this.language = b.language;
        this.hints = b.hints;
        this.bargeIn = b.bargeIn;
        this.debug = b.debug;
        this.actionOnEmptyResult = b.actionOnEmptyResult;
        this.speechModel = b.speechModel;
        this.enhanced = b.enhanced;
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getInputs() != null) {
            attrs.put("input", this.getInputsAsString());
        }
        if (this.getAction() != null) {
            attrs.put("action", this.getAction().toString());
        }
        if (this.getMethod() != null) {
            attrs.put("method", this.getMethod().toString());
        }
        if (this.getTimeout() != null) {
            attrs.put("timeout", this.getTimeout().toString());
        }
        if (this.getSpeechTimeout() != null) {
            attrs.put("speechTimeout", this.getSpeechTimeout());
        }
        if (this.getMaxSpeechTime() != null) {
            attrs.put("maxSpeechTime", this.getMaxSpeechTime().toString());
        }
        if (this.isProfanityFilter() != null) {
            attrs.put("profanityFilter", this.isProfanityFilter().toString());
        }
        if (this.getFinishOnKey() != null) {
            attrs.put("finishOnKey", this.getFinishOnKey());
        }
        if (this.getNumDigits() != null) {
            attrs.put("numDigits", this.getNumDigits().toString());
        }
        if (this.getPartialResultCallback() != null) {
            attrs.put("partialResultCallback", this.getPartialResultCallback().toString());
        }
        if (this.getPartialResultCallbackMethod() != null) {
            attrs.put("partialResultCallbackMethod", this.getPartialResultCallbackMethod().toString());
        }
        if (this.getLanguage() != null) {
            attrs.put("language", this.getLanguage().toString());
        }
        if (this.getHints() != null) {
            attrs.put("hints", this.getHints());
        }
        if (this.isBargeIn() != null) {
            attrs.put("bargeIn", this.isBargeIn().toString());
        }
        if (this.isDebug() != null) {
            attrs.put("debug", this.isDebug().toString());
        }
        if (this.isActionOnEmptyResult() != null) {
            attrs.put("actionOnEmptyResult", this.isActionOnEmptyResult().toString());
        }
        if (this.getSpeechModel() != null) {
            attrs.put("speechModel", this.getSpeechModel().toString());
        }
        if (this.isEnhanced() != null) {
            attrs.put("enhanced", this.isEnhanced().toString());
        }
        return attrs;
    }

    public List<Input> getInputs() {
        return this.input;
    }

    protected String getInputsAsString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Input> iter = this.getInputs().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public URI getAction() {
        return this.action;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public String getSpeechTimeout() {
        return this.speechTimeout;
    }

    public Integer getMaxSpeechTime() {
        return this.maxSpeechTime;
    }

    public Boolean isProfanityFilter() {
        return this.profanityFilter;
    }

    public String getFinishOnKey() {
        return this.finishOnKey;
    }

    public Integer getNumDigits() {
        return this.numDigits;
    }

    public URI getPartialResultCallback() {
        return this.partialResultCallback;
    }

    public HttpMethod getPartialResultCallbackMethod() {
        return this.partialResultCallbackMethod;
    }

    public Language getLanguage() {
        return this.language;
    }

    public String getHints() {
        return this.hints;
    }

    public Boolean isBargeIn() {
        return this.bargeIn;
    }

    public Boolean isDebug() {
        return this.debug;
    }

    public Boolean isActionOnEmptyResult() {
        return this.actionOnEmptyResult;
    }

    public SpeechModel getSpeechModel() {
        return this.speechModel;
    }

    public Boolean isEnhanced() {
        return this.enhanced;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends TwiML.Builder<Builder> {
        private List<Input> input;
        private URI action;
        private HttpMethod method;
        private Integer timeout;
        private String speechTimeout;
        private Integer maxSpeechTime;
        private Boolean profanityFilter;
        private String finishOnKey;
        private Integer numDigits;
        private URI partialResultCallback;
        private HttpMethod partialResultCallbackMethod;
        private Language language;
        private String hints;
        private Boolean bargeIn;
        private Boolean debug;
        private Boolean actionOnEmptyResult;
        private SpeechModel speechModel;
        private Boolean enhanced;

        public static Builder fromXml(String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            }
            catch (JsonProcessingException jpe) {
                throw new TwiMLException("Failed to deserialize a Gather.Builder from the provided XML string: " + jpe.getMessage());
            }
            catch (Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        @JacksonXmlProperty(isAttribute=true, localName="input")
        public Builder inputs(List<Input> input) {
            this.input = input;
            return this;
        }

        public Builder inputs(Input input) {
            this.input = Promoter.listOfOne(input);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="action")
        public Builder action(URI action) {
            this.action = action;
            return this;
        }

        public Builder action(String action) {
            this.action = Promoter.uriFromString(action);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="method")
        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="timeout")
        public Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="speechTimeout")
        public Builder speechTimeout(String speechTimeout) {
            this.speechTimeout = speechTimeout;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="maxSpeechTime")
        public Builder maxSpeechTime(Integer maxSpeechTime) {
            this.maxSpeechTime = maxSpeechTime;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="profanityFilter")
        public Builder profanityFilter(Boolean profanityFilter) {
            this.profanityFilter = profanityFilter;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="finishOnKey")
        public Builder finishOnKey(String finishOnKey) {
            this.finishOnKey = finishOnKey;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="numDigits")
        public Builder numDigits(Integer numDigits) {
            this.numDigits = numDigits;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="partialResultCallback")
        public Builder partialResultCallback(URI partialResultCallback) {
            this.partialResultCallback = partialResultCallback;
            return this;
        }

        public Builder partialResultCallback(String partialResultCallback) {
            this.partialResultCallback = Promoter.uriFromString(partialResultCallback);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="partialResultCallbackMethod")
        public Builder partialResultCallbackMethod(HttpMethod partialResultCallbackMethod) {
            this.partialResultCallbackMethod = partialResultCallbackMethod;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="language")
        public Builder language(Language language) {
            this.language = language;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="hints")
        public Builder hints(String hints) {
            this.hints = hints;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="bargeIn")
        public Builder bargeIn(Boolean bargeIn) {
            this.bargeIn = bargeIn;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="debug")
        public Builder debug(Boolean debug) {
            this.debug = debug;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="actionOnEmptyResult")
        public Builder actionOnEmptyResult(Boolean actionOnEmptyResult) {
            this.actionOnEmptyResult = actionOnEmptyResult;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="speechModel")
        public Builder speechModel(SpeechModel speechModel) {
            this.speechModel = speechModel;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="enhanced")
        public Builder enhanced(Boolean enhanced) {
            this.enhanced = enhanced;
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="Say")
        public Builder say(Say say) {
            this.children.add(say);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="Pause")
        public Builder pause(Pause pause) {
            this.children.add(pause);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="Play")
        public Builder play(Play play) {
            this.children.add(play);
            return this;
        }

        public Gather build() {
            return new Gather(this);
        }
    }

    public static enum SpeechModel {
        DEFAULT("default"),
        NUMBERS_AND_COMMANDS("numbers_and_commands"),
        PHONE_CALL("phone_call"),
        EXPERIMENTAL_CONVERSATIONS("experimental_conversations"),
        EXPERIMENTAL_UTTERANCES("experimental_utterances");

        private final String value;

        private SpeechModel(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Language {
        AF_ZA("af-ZA"),
        AM_ET("am-ET"),
        AR_AE("ar-AE"),
        AR_BH("ar-BH"),
        AR_DZ("ar-DZ"),
        AR_EG("ar-EG"),
        AR_IL("ar-IL"),
        AR_IQ("ar-IQ"),
        AR_JO("ar-JO"),
        AR_KW("ar-KW"),
        AR_LB("ar-LB"),
        AR_MA("ar-MA"),
        AR_OM("ar-OM"),
        AR_PS("ar-PS"),
        AR_QA("ar-QA"),
        AR_SA("ar-SA"),
        AR_TN("ar-TN"),
        AZ_AZ("az-AZ"),
        BG_BG("bg-BG"),
        BN_BD("bn-BD"),
        BN_IN("bn-IN"),
        CA_ES("ca-ES"),
        CS_CZ("cs-CZ"),
        DA_DK("da-DK"),
        DE_DE("de-DE"),
        EL_GR("el-GR"),
        EN_AU("en-AU"),
        EN_CA("en-CA"),
        EN_GB("en-GB"),
        EN_GH("en-GH"),
        EN_IE("en-IE"),
        EN_IN("en-IN"),
        EN_KE("en-KE"),
        EN_NG("en-NG"),
        EN_NZ("en-NZ"),
        EN_PH("en-PH"),
        EN_SG("en-SG"),
        EN_TZ("en-TZ"),
        EN_US("en-US"),
        EN_ZA("en-ZA"),
        ES_AR("es-AR"),
        ES_BO("es-BO"),
        ES_CL("es-CL"),
        ES_CO("es-CO"),
        ES_CR("es-CR"),
        ES_DO("es-DO"),
        ES_EC("es-EC"),
        ES_ES("es-ES"),
        ES_GT("es-GT"),
        ES_HN("es-HN"),
        ES_MX("es-MX"),
        ES_NI("es-NI"),
        ES_PA("es-PA"),
        ES_PE("es-PE"),
        ES_PR("es-PR"),
        ES_PY("es-PY"),
        ES_SV("es-SV"),
        ES_US("es-US"),
        ES_UY("es-UY"),
        ES_VE("es-VE"),
        ET_EE("et-EE"),
        EU_ES("eu-ES"),
        FA_IR("fa-IR"),
        FI_FI("fi-FI"),
        FIL_PH("fil-PH"),
        FR_CA("fr-CA"),
        FR_FR("fr-FR"),
        GL_ES("gl-ES"),
        GU_IN("gu-IN"),
        HE_IL("he-IL"),
        HI_IN("hi-IN"),
        HR_HR("hr-HR"),
        HU_HU("hu-HU"),
        HY_AM("hy-AM"),
        ID_ID("id-ID"),
        IS_IS("is-IS"),
        IT_IT("it-IT"),
        JA_JP("ja-JP"),
        JV_ID("jv-ID"),
        KA_GE("ka-GE"),
        KM_KH("km-KH"),
        KN_IN("kn-IN"),
        KO_KR("ko-KR"),
        LO_LA("lo-LA"),
        LT_LT("lt-LT"),
        LV_LV("lv-LV"),
        MK_MK("mk-MK"),
        ML_IN("ml-IN"),
        MN_MN("mn-MN"),
        MR_IN("mr-IN"),
        MS_MY("ms-MY"),
        MY_MM("my-MM"),
        NAR_IQ("nar-IQ"),
        NB_NO("nb-NO"),
        NE_NP("ne-NP"),
        NL_BE("nl-BE"),
        NL_NL("nl-NL"),
        PA_GURU_IN("pa-guru-IN"),
        PL_PL("pl-PL"),
        PT_BR("pt-BR"),
        PT_PT("pt-PT"),
        RO_RO("ro-RO"),
        RU_RU("ru-RU"),
        SI_LK("si-LK"),
        SK_SK("sk-SK"),
        SL_SI("sl-SI"),
        SQ_AL("sq-AL"),
        SR_RS("sr-RS"),
        SU_ID("su-ID"),
        SV_SE("sv-SE"),
        SW_KE("sw-KE"),
        SW_TZ("sw-TZ"),
        TA_IN("ta-IN"),
        TA_LK("ta-LK"),
        TA_MY("ta-MY"),
        TA_SG("ta-SG"),
        TE_IN("te-IN"),
        TH_TH("th-TH"),
        TR_TR("tr-TR"),
        UK_UA("uk-UA"),
        UR_IN("ur-IN"),
        UR_PK("ur-PK"),
        UZ_UZ("uz-UZ"),
        VI_VN("vi-VN"),
        YUE_HANT_HK("yue-Hant-HK"),
        ZH("zh"),
        CMN_HANS_CN("cmn-Hans-CN"),
        ZH_TW("zh-TW"),
        CMN_HANT_TW("cmn-Hant-TW"),
        ZU_ZA("zu-ZA");

        private final String value;

        private Language(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Input {
        DTMF("dtmf"),
        SPEECH("speech");

        private final String value;

        private Input(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

