/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;
import com.twilio.twiml.voice.SsmlBreak;
import com.twilio.twiml.voice.SsmlEmphasis;
import com.twilio.twiml.voice.SsmlLang;
import com.twilio.twiml.voice.SsmlPhoneme;
import com.twilio.twiml.voice.SsmlProsody;
import com.twilio.twiml.voice.SsmlSayAs;
import com.twilio.twiml.voice.SsmlSub;
import com.twilio.twiml.voice.SsmlW;

@JsonDeserialize(builder=Builder.class)
public class SsmlS
extends TwiML {
    private final String words;

    private SsmlS() {
        this(new Builder());
    }

    private SsmlS(Builder b) {
        super("s", b);
        this.words = b.words;
    }

    @Override
    protected String getElementBody() {
        return this.getWords() == null ? null : this.getWords();
    }

    public String getWords() {
        return this.words;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends TwiML.Builder<Builder> {
        private String words;

        public static Builder fromXml(String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            }
            catch (JsonProcessingException jpe) {
                throw new TwiMLException("Failed to deserialize a SsmlS.Builder from the provided XML string: " + jpe.getMessage());
            }
            catch (Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        public Builder(String words) {
            this.words = words;
        }

        public Builder() {
        }

        @JacksonXmlProperty(isAttribute=false, localName="break")
        public Builder break_(SsmlBreak ssmlBreak) {
            this.children.add(ssmlBreak);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="emphasis")
        public Builder emphasis(SsmlEmphasis ssmlEmphasis) {
            this.children.add(ssmlEmphasis);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="lang")
        public Builder lang(SsmlLang ssmlLang) {
            this.children.add(ssmlLang);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="phoneme")
        public Builder phoneme(SsmlPhoneme ssmlPhoneme) {
            this.children.add(ssmlPhoneme);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="prosody")
        public Builder prosody(SsmlProsody ssmlProsody) {
            this.children.add(ssmlProsody);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="say-as")
        public Builder sayAs(SsmlSayAs ssmlSayAs) {
            this.children.add(ssmlSayAs);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="sub")
        public Builder sub(SsmlSub ssmlSub) {
            this.children.add(ssmlSub);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="w")
        public Builder w(SsmlW ssmlW) {
            this.children.add(ssmlW);
            return this;
        }

        public SsmlS build() {
            return new SsmlS(this);
        }
    }
}

