/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twilio;

import com.twilio.http.TwilioRestClient;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.twilio.TwilioConfiguration;
import org.apache.camel.component.twilio.TwilioEndpoint;
import org.apache.camel.component.twilio.internal.TwilioApiCollection;
import org.apache.camel.component.twilio.internal.TwilioApiName;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.component.AbstractApiComponent;
import org.apache.camel.util.ObjectHelper;

@Component(value="twilio")
public class TwilioComponent
extends AbstractApiComponent<TwilioApiName, TwilioConfiguration, TwilioApiCollection> {
    @Metadata
    private TwilioConfiguration configuration = new TwilioConfiguration();
    @Metadata(label="common,security", secret=true)
    private String username;
    @Metadata(label="common,security", secret=true)
    private String password;
    @Metadata(label="common,security", secret=true)
    private String accountSid;
    @Metadata(label="advanced", autowired=true)
    private TwilioRestClient restClient;

    public TwilioComponent() {
        super(TwilioApiName.class, TwilioApiCollection.getCollection());
    }

    public TwilioComponent(CamelContext context) {
        super(context, TwilioApiName.class, TwilioApiCollection.getCollection());
    }

    @Override
    protected TwilioApiName getApiName(String apiNameStr) {
        return this.getCamelContext().getTypeConverter().convertTo(TwilioApiName.class, apiNameStr);
    }

    @Override
    protected Endpoint createEndpoint(String uri, String methodName, TwilioApiName apiName, TwilioConfiguration endpointConfiguration) {
        endpointConfiguration.setApiName(apiName);
        endpointConfiguration.setMethodName(methodName);
        return new TwilioEndpoint(uri, this, apiName, methodName, endpointConfiguration);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.restClient == null) {
            if (ObjectHelper.isEmpty(this.username) && ObjectHelper.isEmpty(this.password)) {
                throw new IllegalStateException("Unable to initialise Twilio, Twilio component configuration is missing");
            }
            if (ObjectHelper.isEmpty(this.accountSid)) {
                this.accountSid = this.username;
            }
            this.restClient = new TwilioRestClient.Builder(this.username, this.password).accountSid(this.accountSid).build();
        }
    }

    @Override
    public void doShutdown() throws Exception {
        this.restClient = null;
        super.doShutdown();
    }

    @Override
    public TwilioConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(TwilioConfiguration configuration) {
        this.configuration = configuration;
    }

    public TwilioRestClient getRestClient() {
        return this.restClient;
    }

    public void setRestClient(TwilioRestClient restClient) {
        this.restClient = restClient;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAccountSid() {
        return this.accountSid;
    }

    public void setAccountSid(String accountSid) {
        this.accountSid = accountSid;
    }
}

